// Admin panel JavaScript dosyası
document.addEventListener('DOMContentLoaded', function() {
    // Form validasyonları
    const forms = document.querySelectorAll('form');
    forms.forEach(form => {
        form.addEventListener('submit', function(e) {
            const requiredFields = form.querySelectorAll('[required]');
            let isValid = true;
            
            requiredFields.forEach(field => {
                if (!field.value.trim()) {
                    field.style.borderColor = '#ef4444';
                    isValid = false;
                } else {
                    field.style.borderColor = '#2d4b7b';
                }
            });
            
            if (!isValid) {
                e.preventDefault();
                alert('Lütfen tüm zorunlu alanları doldurun!');
            }
        });
    });
    
    // Tablo sıralama (basit)
    const tableHeaders = document.querySelectorAll('.data-table th');
    tableHeaders.forEach(header => {
        header.style.cursor = 'pointer';
        header.addEventListener('click', function() {
            // Burada tablo sıralama fonksiyonu eklenebilir
            console.log('Sıralama: ' + this.textContent);
        });
    });
});