<?php
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/includes/session.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
	$username = trim($_POST['username'] ?? '');
	$password = trim($_POST['password'] ?? '');

	if ($username === '' || $password === '') {
		$error = 'Kullanıcı adı ve şifre gerekli.';
	} else {
		$stmt = $pdo->prepare('SELECT id, password, full_name FROM users WHERE username = ? AND user_type = "admin" LIMIT 1');
		$stmt->execute([$username]);
		$user = $stmt->fetch();

		if ($user && password_verify($password, $user['password'])) {
			$_SESSION['admin_id'] = $user['id'];
			$_SESSION['admin_name'] = $user['full_name'];
			header('Location: /admin/index.php');
			exit;
		} else {
			$error = 'Geçersiz kullanıcı adı veya şifre.';
		}
	}
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
	<meta charset="UTF-8">
	<title>Admin Giriş - BAŞKENT 1910 GÜCÜ SK</title>
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
	<link rel="stylesheet" href="/admin/css/style.css">
</head>
<body>
	<div class="login-container">
		<!-- Logo Bölümü -->
		<div class="login-logo">
			<img src="/admin/images/logo.png" alt="BAŞKENT 1910 GÜCÜ SK Logo" onerror="this.src='/admin/images/logo.jpg'; this.onerror=function(){this.src='/admin/images/logo.svg'; this.onerror=function(){this.style.display='none'; this.nextElementSibling.style.display='block';};};">
			<div class="login-logo-fallback" style="display: none;">
				<i class="fas fa-futbol"></i>
			</div>
			<h1 class="login-logo-title">BAŞKENT 1910 GÜCÜ SK</h1>
			<p class="login-logo-subtitle">Spor Kulübü Yönetim Sistemi</p>
		</div>
		
		<!-- Login Formu -->
		<form method="post" action="">
			<?php if ($error): ?>
				<div class="alert"><?php echo htmlspecialchars($error); ?></div>
			<?php endif; ?>
			<label>Kullanıcı Adı</label>
			<input type="text" name="username" required>
			<label>Şifre</label>
			<input type="password" name="password" required>
			<button type="submit">Giriş Yap</button>
		</form>
	</div>
</body>
</html>