<?php
$page_title = 'Yedekleme Sistemi - BAŞKENT 1910 GÜCÜ SK';
require_once __DIR__ . '/../includes/header.php';

$action = $_GET['action'] ?? 'list';
$message = '';
$error = '';

// Yedekleme dizini
$backup_dir = __DIR__ . '/../backups/';
if (!is_dir($backup_dir)) {
    mkdir($backup_dir, 0755, true);
}

// Manuel yedekleme oluşturma
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $action === 'create_backup') {
    try {
        $backup_name = 'backup_' . date('Y-m-d_H-i-s') . '.sql';
        $backup_path = $backup_dir . $backup_name;
        
        // Veritabanı yedekleme komutu
        $db_host = 'localhost';
        $db_name = 'baskent1910guksk';
        $db_user = 'root';
        $db_pass = '';
        
        // MySQL dump komutu
        $command = "mysqldump --host={$db_host} --user={$db_user} --password={$db_pass} --single-transaction --routines --triggers {$db_name} > " . escapeshellarg($backup_path);
        
        // Komutu çalıştır
        $output = [];
        $return_var = 0;
        exec($command, $output, $return_var);
        
        if ($return_var === 0 && file_exists($backup_path)) {
            // Yedekleme bilgilerini veritabanına kaydet
            $stmt = $pdo->prepare("
                INSERT INTO backup_history (backup_name, backup_path, backup_size, created_by, backup_type) 
                VALUES (?, ?, ?, ?, 'manual')
            ");
            $stmt->execute([
                $backup_name,
                $backup_path,
                filesize($backup_path),
                $_SESSION['admin_id']
            ]);
            
            $message = "Yedekleme başarıyla oluşturuldu!";
        } else {
            $error = "Yedekleme oluşturulurken hata oluştu!";
        }
    } catch (Exception $e) {
        $error = "Hata: " . $e->getMessage();
    }
}

// Otomatik yedekleme ayarları
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $action === 'save_auto_backup') {
    $auto_backup_enabled = isset($_POST['auto_backup_enabled']) ? 1 : 0;
    $backup_frequency = $_POST['backup_frequency'] ?? 'daily';
    $backup_retention = $_POST['backup_retention'] ?? '30';
    
    try {
        // Ayarları veritabanına kaydet
        $stmt = $pdo->prepare("
            INSERT INTO system_settings (setting_key, setting_value, description) 
            VALUES (?, ?, ?) 
            ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)
        ");
        
        $stmt->execute(['auto_backup_enabled', $auto_backup_enabled, 'Otomatik yedekleme aktif mi']);
        $stmt->execute(['backup_frequency', $backup_frequency, 'Yedekleme sıklığı']);
        $stmt->execute(['backup_retention', $backup_retention, 'Yedekleme saklama süresi (gün)']);
        
        $message = "Otomatik yedekleme ayarları kaydedildi!";
    } catch (Exception $e) {
        $error = "Hata: " . $e->getMessage();
    }
}

// Yedekleme geri yükleme
if ($action === 'restore' && isset($_GET['id'])) {
    try {
        $stmt = $pdo->prepare("SELECT * FROM backup_history WHERE id = ?");
        $stmt->execute([$_GET['id']]);
        $backup = $stmt->fetch();
        
        if ($backup && file_exists($backup['backup_path'])) {
            // Veritabanını geri yükle
            $db_host = 'localhost';
            $db_name = 'baskent1910guksk';
            $db_user = 'root';
            $db_pass = '';
            
            $command = "mysql --host={$db_host} --user={$db_user} --password={$db_pass} {$db_name} < " . escapeshellarg($backup['backup_path']);
            
            $output = [];
            $return_var = 0;
            exec($command, $output, $return_var);
            
            if ($return_var === 0) {
                $message = "Yedekleme başarıyla geri yüklendi!";
            } else {
                $error = "Geri yükleme sırasında hata oluştu!";
            }
        } else {
            $error = "Yedekleme dosyası bulunamadı!";
        }
    } catch (Exception $e) {
        $error = "Hata: " . $e->getMessage();
    }
}

// Yedekleme silme
if ($action === 'delete' && isset($_GET['id'])) {
    try {
        $stmt = $pdo->prepare("SELECT * FROM backup_history WHERE id = ?");
        $stmt->execute([$_GET['id']]);
        $backup = $stmt->fetch();
        
        if ($backup) {
            // Dosyayı sil
            if (file_exists($backup['backup_path'])) {
                unlink($backup['backup_path']);
            }
            
            // Veritabanından sil
            $stmt = $pdo->prepare("DELETE FROM backup_history WHERE id = ?");
            $stmt->execute([$_GET['id']]);
            
            $message = "Yedekleme başarıyla silindi!";
        }
    } catch (Exception $e) {
        $error = "Hata: " . $e->getMessage();
    }
}

// Yedekleme geçmişi
$backups = $pdo->query("
    SELECT bh.*, u.full_name as created_by_name
    FROM backup_history bh
    LEFT JOIN users u ON bh.created_by = u.id
    ORDER BY bh.created_at DESC
")->fetchAll();

// Sistem ayarları
$settings = [];
$stmt = $pdo->query("SELECT setting_key, setting_value FROM system_settings WHERE setting_key IN ('auto_backup_enabled', 'backup_frequency', 'backup_retention')");
while ($row = $stmt->fetch()) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

// Varsayılan değerler
$auto_backup_enabled = $settings['auto_backup_enabled'] ?? '0';
$backup_frequency = $settings['backup_frequency'] ?? 'daily';
$backup_retention = $settings['backup_retention'] ?? '30';

// Disk kullanımı
$total_space = disk_total_space($backup_dir);
$free_space = disk_free_space($backup_dir);
$used_space = $total_space - $free_space;

// Yedekleme istatistikleri
$backup_stats = [];
$stmt = $pdo->query("SELECT COUNT(*) as total FROM backup_history");
$backup_stats['total_backups'] = $stmt->fetch()['total'];

$stmt = $pdo->query("SELECT SUM(backup_size) as total_size FROM backup_history");
$backup_stats['total_size'] = $stmt->fetch()['total_size'] ?? 0;

$stmt = $pdo->query("SELECT COUNT(*) as total FROM backup_history WHERE created_at >= DATE_SUB(NOW(), INTERVAL 7 DAY)");
$backup_stats['recent_backups'] = $stmt->fetch()['total'];
?>

<div class="page-header">
    <div class="page-title">
        <i class="fas fa-database"></i>
        <h2>Yedekleme Sistemi</h2>
    </div>
    <div class="header-actions">
        <a href="?action=create_backup" class="btn btn-primary" onclick="return confirm('Yedekleme oluşturmak istediğinizden emin misiniz?')">
            <i class="fas fa-plus"></i>
            <span>Manuel Yedekleme</span>
        </a>
    </div>
</div>

<?php if ($message): ?>
    <div class="alert alert-success">
        <i class="fas fa-check-circle"></i>
        <?php echo htmlspecialchars($message); ?>
    </div>
<?php endif; ?>

<?php if ($error): ?>
    <div class="alert alert-error">
        <i class="fas fa-exclamation-circle"></i>
        <?php echo htmlspecialchars($error); ?>
    </div>
<?php endif; ?>

<!-- Yedekleme İstatistikleri -->
<div class="backup-stats">
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-database"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo $backup_stats['total_backups']; ?></h3>
                <p>Toplam Yedekleme</p>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-hdd"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo formatBytes($backup_stats['total_size']); ?></h3>
                <p>Toplam Boyut</p>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-clock"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo $backup_stats['recent_backups']; ?></h3>
                <p>Son 7 Gün</p>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-chart-pie"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo round(($used_space / $total_space) * 100, 1); ?>%</h3>
                <p>Disk Kullanımı</p>
            </div>
        </div>
    </div>
</div>

<!-- Otomatik Yedekleme Ayarları -->
<div class="settings-container">
    <h3><i class="fas fa-cogs"></i> Otomatik Yedekleme Ayarları</h3>
    
    <form method="post" action="">
        <input type="hidden" name="action" value="save_auto_backup">
        
        <div class="form-row">
            <div class="form-group">
                <label>
                    <input type="checkbox" name="auto_backup_enabled" value="1" <?php echo $auto_backup_enabled ? 'checked' : ''; ?>>
                    Otomatik Yedekleme Aktif
                </label>
            </div>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label>Yedekleme Sıklığı</label>
                <select name="backup_frequency">
                    <option value="hourly" <?php echo $backup_frequency === 'hourly' ? 'selected' : ''; ?>>Saatlik</option>
                    <option value="daily" <?php echo $backup_frequency === 'daily' ? 'selected' : ''; ?>>Günlük</option>
                    <option value="weekly" <?php echo $backup_frequency === 'weekly' ? 'selected' : ''; ?>>Haftalık</option>
                    <option value="monthly" <?php echo $backup_frequency === 'monthly' ? 'selected' : ''; ?>>Aylık</option>
                </select>
            </div>
            
            <div class="form-group">
                <label>Yedekleme Saklama Süresi (Gün)</label>
                <input type="number" name="backup_retention" value="<?php echo $backup_retention; ?>" min="1" max="365">
            </div>
        </div>
        
        <div class="form-actions">
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save"></i>
                <span>Ayarları Kaydet</span>
            </button>
        </div>
    </form>
</div>

<!-- Yedekleme Geçmişi -->
<div class="table-container">
    <div class="table-header">
        <h3><i class="fas fa-history"></i> Yedekleme Geçmişi</h3>
        <div class="table-actions">
            <button onclick="refreshBackups()" class="btn btn-sm btn-secondary">
                <i class="fas fa-sync"></i>
                <span>Yenile</span>
            </button>
        </div>
    </div>
    
    <table class="data-table">
        <thead>
            <tr>
                <th>Yedekleme Adı</th>
                <th>Boyut</th>
                <th>Tür</th>
                <th>Oluşturan</th>
                <th>Tarih</th>
                <th>İşlemler</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($backups as $backup): ?>
                <tr>
                    <td>
                        <div class="backup-info">
                            <i class="fas fa-database"></i>
                            <span><?php echo htmlspecialchars($backup['backup_name']); ?></span>
                        </div>
                    </td>
                    <td><?php echo formatBytes($backup['backup_size']); ?></td>
                    <td>
                        <span class="status status-<?php echo $backup['backup_type']; ?>">
                            <?php echo $backup['backup_type'] === 'manual' ? 'Manuel' : 'Otomatik'; ?>
                        </span>
                    </td>
                    <td><?php echo htmlspecialchars($backup['created_by_name'] ?? 'Sistem'); ?></td>
                    <td><?php echo date('d.m.Y H:i', strtotime($backup['created_at'])); ?></td>
                    <td>
                        <div class="action-buttons">
                            <a href="?action=restore&id=<?php echo $backup['id']; ?>" 
                               class="btn btn-sm btn-warning"
                               onclick="return confirm('Bu yedeklemeyi geri yüklemek istediğinizden emin misiniz? Tüm mevcut veriler silinecektir!')">
                                <i class="fas fa-undo"></i>
                                <span>Geri Yükle</span>
                            </a>
                            <a href="?action=download&id=<?php echo $backup['id']; ?>" 
                               class="btn btn-sm btn-info">
                                <i class="fas fa-download"></i>
                                <span>İndir</span>
                            </a>
                            <a href="?action=delete&id=<?php echo $backup['id']; ?>" 
                               class="btn btn-sm btn-danger"
                               onclick="return confirm('Bu yedeklemeyi silmek istediğinizden emin misiniz?')">
                                <i class="fas fa-trash"></i>
                                <span>Sil</span>
                            </a>
                        </div>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<!-- Disk Kullanımı -->
<div class="disk-usage">
    <h3><i class="fas fa-hdd"></i> Disk Kullanımı</h3>
    <div class="usage-bar">
        <div class="usage-fill" style="width: <?php echo ($used_space / $total_space) * 100; ?>%"></div>
        <div class="usage-text">
            <?php echo formatBytes($used_space); ?> / <?php echo formatBytes($total_space); ?>
            (<?php echo round(($used_space / $total_space) * 100, 1); ?>%)
        </div>
    </div>
</div>

<script>
function refreshBackups() {
    location.reload();
}

function formatBytes(bytes) {
    if (bytes === 0) return '0 Bytes';
    const k = 1024;
    const sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB'];
    const i = Math.floor(Math.log(bytes) / Math.log(k));
    return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
}
</script>

<?php
// Yardımcı fonksiyonlar
function formatBytes($bytes, $precision = 2) {
    $units = array('B', 'KB', 'MB', 'GB', 'TB');
    
    for ($i = 0; $bytes > 1024 && $i < count($units) - 1; $i++) {
        $bytes /= 1024;
    }
    
    return round($bytes, $precision) . ' ' . $units[$i];
}

// Yedekleme indirme
if ($action === 'download' && isset($_GET['id'])) {
    $stmt = $pdo->prepare("SELECT * FROM backup_history WHERE id = ?");
    $stmt->execute([$_GET['id']]);
    $backup = $stmt->fetch();
    
    if ($backup && file_exists($backup['backup_path'])) {
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="' . $backup['backup_name'] . '"');
        header('Content-Length: ' . filesize($backup['backup_path']));
        readfile($backup['backup_path']);
        exit;
    } else {
        $error = "Yedekleme dosyası bulunamadı!";
    }
}
?>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>