<?php
$page_title = 'Kasa Yönetimi - BAŞKENT 1910 GÜCÜ SK';
require_once __DIR__ . '/../includes/header.php';

$action = $_GET['action'] ?? 'list';
$message = '';
$error = '';

// Kasa işlemi ekleme
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $action === 'add_transaction') {
    $transaction_type = $_POST['transaction_type'] ?? '';
    $category = trim($_POST['category'] ?? '');
    $amount = floatval($_POST['amount'] ?? 0);
    $description = trim($_POST['description'] ?? '');
    $payment_method = $_POST['payment_method'] ?? 'cash';
    $transaction_date = $_POST['transaction_date'] ?? date('Y-m-d');
    
    if ($transaction_type && $category && $amount > 0) {
        try {
            $stmt = $pdo->prepare("
                INSERT INTO cash_transactions 
                (transaction_type, category, amount, description, payment_method, transaction_date, created_by) 
                VALUES (?, ?, ?, ?, ?, ?, ?)
            ");
            $stmt->execute([
                $transaction_type, 
                $category, 
                $amount, 
                $description, 
                $payment_method, 
                $transaction_date, 
                $_SESSION['admin_id']
            ]);
            
            $message = "Kasa işlemi başarıyla eklendi!";
        } catch (Exception $e) {
            $error = "Hata: " . $e->getMessage();
        }
    } else {
        $error = "Lütfen tüm alanları doğru şekilde doldurun!";
    }
}

// Kasa işlemi düzenleme
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $action === 'edit_transaction') {
    $transaction_id = $_POST['transaction_id'] ?? '';
    $transaction_type = $_POST['transaction_type'] ?? '';
    $category = trim($_POST['category'] ?? '');
    $amount = floatval($_POST['amount'] ?? 0);
    $description = trim($_POST['description'] ?? '');
    $payment_method = $_POST['payment_method'] ?? 'cash';
    $transaction_date = $_POST['transaction_date'] ?? date('Y-m-d');
    
    if ($transaction_id && $transaction_type && $category && $amount > 0) {
        try {
            $stmt = $pdo->prepare("
                UPDATE cash_transactions 
                SET transaction_type = ?, category = ?, amount = ?, description = ?, 
                    payment_method = ?, transaction_date = ?, updated_at = NOW()
                WHERE id = ?
            ");
            $stmt->execute([
                $transaction_type, 
                $category, 
                $amount, 
                $description, 
                $payment_method, 
                $transaction_date, 
                $transaction_id
            ]);
            
            $message = "Kasa işlemi başarıyla güncellendi!";
            $action = 'list';
        } catch (Exception $e) {
            $error = "Hata: " . $e->getMessage();
        }
    } else {
        $error = "Lütfen tüm alanları doğru şekilde doldurun!";
    }
}

// Kasa işlemi silme
if ($action === 'delete_transaction' && isset($_GET['id'])) {
    try {
        $stmt = $pdo->prepare("DELETE FROM cash_transactions WHERE id = ?");
        $stmt->execute([$_GET['id']]);
        $message = "Kasa işlemi başarıyla silindi!";
    } catch (Exception $e) {
        $error = "Hata: " . $e->getMessage();
    }
    $action = 'list';
}

// Kategori ekleme
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $action === 'add_category') {
    $category_name = trim($_POST['category_name'] ?? '');
    $category_type = $_POST['category_type'] ?? '';
    $description = trim($_POST['description'] ?? '');
    
    if ($category_name && $category_type) {
        try {
            $stmt = $pdo->prepare("
                INSERT INTO cash_categories (category_name, category_type, description) 
                VALUES (?, ?, ?)
            ");
            $stmt->execute([$category_name, $category_type, $description]);
            $message = "Kategori başarıyla eklendi!";
        } catch (Exception $e) {
            $error = "Hata: " . $e->getMessage();
        }
    } else {
        $error = "Lütfen kategori adı ve türünü seçin!";
    }
}

// Düzenleme için işlem bilgileri
$edit_transaction = null;
if ($action === 'edit_transaction' && isset($_GET['id'])) {
    $stmt = $pdo->prepare("SELECT * FROM cash_transactions WHERE id = ?");
    $stmt->execute([$_GET['id']]);
    $edit_transaction = $stmt->fetch();
}

// Kasa istatistikleri
$stats = [];
$stmt = $pdo->query("SELECT SUM(amount) as total FROM cash_transactions WHERE transaction_type = 'income' AND transaction_date >= DATE_SUB(NOW(), INTERVAL 30 DAY)");
$stats['monthly_income'] = $stmt->fetch()['total'] ?? 0;

$stmt = $pdo->query("SELECT SUM(amount) as total FROM cash_transactions WHERE transaction_type = 'expense' AND transaction_date >= DATE_SUB(NOW(), INTERVAL 30 DAY)");
$stats['monthly_expense'] = $stmt->fetch()['total'] ?? 0;

$stats['monthly_balance'] = $stats['monthly_income'] - $stats['monthly_expense'];

$stmt = $pdo->query("SELECT SUM(amount) as total FROM cash_transactions WHERE transaction_type = 'income'");
$stats['total_income'] = $stmt->fetch()['total'] ?? 0;

$stmt = $pdo->query("SELECT SUM(amount) as total FROM cash_transactions WHERE transaction_type = 'expense'");
$stats['total_expense'] = $stmt->fetch()['total'] ?? 0;

$stats['total_balance'] = $stats['total_income'] - $stats['total_expense'];

// Kategoriler
$income_categories = $pdo->query("SELECT * FROM cash_categories WHERE category_type = 'income' AND is_active = 1 ORDER BY category_name")->fetchAll();
$expense_categories = $pdo->query("SELECT * FROM cash_categories WHERE category_type = 'expense' AND is_active = 1 ORDER BY category_name")->fetchAll();

// Kasa işlemleri listesi
$transactions = $pdo->query("
    SELECT ct.*, u.full_name as created_by_name
    FROM cash_transactions ct
    LEFT JOIN users u ON ct.created_by = u.id
    ORDER BY ct.transaction_date DESC, ct.created_at DESC
    LIMIT 100
")->fetchAll();

// Aylık gelir-gider grafiği
$monthly_chart = $pdo->query("
    SELECT 
        DATE_FORMAT(transaction_date, '%Y-%m') as month,
        SUM(CASE WHEN transaction_type = 'income' THEN amount ELSE 0 END) as income,
        SUM(CASE WHEN transaction_type = 'expense' THEN amount ELSE 0 END) as expense
    FROM cash_transactions 
    WHERE transaction_date >= DATE_SUB(NOW(), INTERVAL 12 MONTH)
    GROUP BY DATE_FORMAT(transaction_date, '%Y-%m')
    ORDER BY month DESC
")->fetchAll();
?>

<div class="page-header">
    <div class="page-title">
        <i class="fas fa-cash-register"></i>
        <h2>Kasa Yönetimi</h2>
    </div>
    <div class="header-actions">
        <a href="?action=add_transaction" class="btn btn-success">
            <i class="fas fa-plus"></i>
            <span>Gelir Ekle</span>
        </a>
        <a href="?action=add_transaction&type=expense" class="btn btn-danger">
            <i class="fas fa-minus"></i>
            <span>Gider Ekle</span>
        </a>
        <a href="?action=categories" class="btn btn-secondary">
            <i class="fas fa-tags"></i>
            <span>Kategoriler</span>
        </a>
    </div>
</div>

<?php if ($message): ?>
    <div class="alert alert-success">
        <i class="fas fa-check-circle"></i>
        <?php echo htmlspecialchars($message); ?>
    </div>
<?php endif; ?>

<?php if ($error): ?>
    <div class="alert alert-error">
        <i class="fas fa-exclamation-circle"></i>
        <?php echo htmlspecialchars($error); ?>
    </div>
<?php endif; ?>

<!-- Kasa İstatistikleri -->
<div class="cash-stats">
    <div class="stats-grid">
        <div class="stat-card income">
            <div class="stat-icon">
                <i class="fas fa-arrow-up"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo number_format($stats['monthly_income'], 2); ?> ₺</h3>
                <p>Bu Ay Gelir</p>
            </div>
        </div>
        
        <div class="stat-card expense">
            <div class="stat-icon">
                <i class="fas fa-arrow-down"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo number_format($stats['monthly_expense'], 2); ?> ₺</h3>
                <p>Bu Ay Gider</p>
            </div>
        </div>
        
        <div class="stat-card balance <?php echo $stats['monthly_balance'] >= 0 ? 'positive' : 'negative'; ?>">
            <div class="stat-icon">
                <i class="fas fa-balance-scale"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo number_format($stats['monthly_balance'], 2); ?> ₺</h3>
                <p>Bu Ay Bakiye</p>
            </div>
        </div>
        
        <div class="stat-card total">
            <div class="stat-icon">
                <i class="fas fa-wallet"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo number_format($stats['total_balance'], 2); ?> ₺</h3>
                <p>Toplam Bakiye</p>
            </div>
        </div>
    </div>
</div>

<?php if ($action === 'add_transaction' || $action === 'edit_transaction'): ?>
    <div class="form-container">
        <h3>
            <i class="fas fa-<?php echo $action === 'edit_transaction' ? 'edit' : 'plus'; ?>"></i>
            <?php echo $action === 'edit_transaction' ? 'Kasa İşlemi Düzenle' : 'Yeni Kasa İşlemi'; ?>
        </h3>
        
        <form method="post" action="">
            <?php if ($action === 'edit_transaction'): ?>
                <input type="hidden" name="transaction_id" value="<?php echo $edit_transaction['id']; ?>">
            <?php endif; ?>
            
            <div class="form-row">
                <div class="form-group">
                    <label>İşlem Türü *</label>
                    <select name="transaction_type" required>
                        <option value="income" <?php echo ($edit_transaction['transaction_type'] ?? ($_GET['type'] ?? '')) === 'income' ? 'selected' : ''; ?>>Gelir</option>
                        <option value="expense" <?php echo ($edit_transaction['transaction_type'] ?? ($_GET['type'] ?? '')) === 'expense' ? 'selected' : ''; ?>>Gider</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>Kategori *</label>
                    <select name="category" required>
                        <option value="">Kategori Seçin</option>
                        <?php 
                        $selected_type = $edit_transaction['transaction_type'] ?? ($_GET['type'] ?? '');
                        $categories = $selected_type === 'expense' ? $expense_categories : $income_categories;
                        foreach ($categories as $category): 
                        ?>
                            <option value="<?php echo htmlspecialchars($category['category_name']); ?>" 
                                    <?php echo ($edit_transaction['category'] ?? '') === $category['category_name'] ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($category['category_name']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-group">
                    <label>Tutar (₺) *</label>
                    <input type="number" name="amount" step="0.01" min="0" required 
                           value="<?php echo $edit_transaction['amount'] ?? ''; ?>" placeholder="0.00">
                </div>
                <div class="form-group">
                    <label>Ödeme Yöntemi</label>
                    <select name="payment_method">
                        <option value="cash" <?php echo ($edit_transaction['payment_method'] ?? 'cash') === 'cash' ? 'selected' : ''; ?>>Nakit</option>
                        <option value="bank_transfer" <?php echo ($edit_transaction['payment_method'] ?? '') === 'bank_transfer' ? 'selected' : ''; ?>>Banka Havalesi</option>
                        <option value="credit_card" <?php echo ($edit_transaction['payment_method'] ?? '') === 'credit_card' ? 'selected' : ''; ?>>Kredi Kartı</option>
                        <option value="check" <?php echo ($edit_transaction['payment_method'] ?? '') === 'check' ? 'selected' : ''; ?>>Çek</option>
                    </select>
                </div>
            </div>
            
            <div class="form-group">
                <label>Açıklama</label>
                <textarea name="description" rows="3" placeholder="İşlem açıklaması..."><?php echo htmlspecialchars($edit_transaction['description'] ?? ''); ?></textarea>
            </div>
            
            <div class="form-group">
                <label>İşlem Tarihi *</label>
                <input type="date" name="transaction_date" required 
                       value="<?php echo $edit_transaction['transaction_date'] ?? date('Y-m-d'); ?>">
            </div>
            
            <div class="form-actions">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i>
                    <span>Kaydet</span>
                </button>
                <a href="?" class="btn btn-secondary">
                    <i class="fas fa-times"></i>
                    <span>İptal</span>
                </a>
            </div>
        </form>
    </div>

<?php elseif ($action === 'categories'): ?>
    <div class="form-container">
        <h3><i class="fas fa-tags"></i> Kategori Yönetimi</h3>
        
        <form method="post" action="">
            <div class="form-row">
                <div class="form-group">
                    <label>Kategori Adı *</label>
                    <input type="text" name="category_name" required placeholder="Kategori adı">
                </div>
                <div class="form-group">
                    <label>Kategori Türü *</label>
                    <select name="category_type" required>
                        <option value="">Tür Seçin</option>
                        <option value="income">Gelir</option>
                        <option value="expense">Gider</option>
                    </select>
                </div>
            </div>
            
            <div class="form-group">
                <label>Açıklama</label>
                <textarea name="description" rows="2" placeholder="Kategori açıklaması..."></textarea>
            </div>
            
            <div class="form-actions">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-plus"></i>
                    <span>Kategori Ekle</span>
                </button>
            </div>
        </form>
    </div>

<?php else: ?>
    <!-- Kasa İşlemleri Listesi -->
    <div class="table-container">
        <div class="table-header">
            <h3><i class="fas fa-list"></i> Kasa İşlemleri</h3>
            <div class="table-actions">
                <a href="?action=add_transaction" class="btn btn-sm btn-success">
                    <i class="fas fa-plus"></i>
                    <span>Gelir Ekle</span>
                </a>
                <a href="?action=add_transaction&type=expense" class="btn btn-sm btn-danger">
                    <i class="fas fa-minus"></i>
                    <span>Gider Ekle</span>
                </a>
            </div>
        </div>
        
        <table class="data-table">
            <thead>
                <tr>
                    <th>Tarih</th>
                    <th>Tür</th>
                    <th>Kategori</th>
                    <th>Tutar</th>
                    <th>Ödeme Yöntemi</th>
                    <th>Açıklama</th>
                    <th>Ekleyen</th>
                    <th>İşlemler</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($transactions as $transaction): ?>
                    <tr>
                        <td><?php echo date('d.m.Y', strtotime($transaction['transaction_date'])); ?></td>
                        <td>
                            <span class="status status-<?php echo $transaction['transaction_type']; ?>">
                                <?php echo $transaction['transaction_type'] === 'income' ? 'Gelir' : 'Gider'; ?>
                            </span>
                        </td>
                        <td><?php echo htmlspecialchars($transaction['category']); ?></td>
                        <td class="<?php echo $transaction['transaction_type'] === 'income' ? 'text-success' : 'text-danger'; ?>">
                            <?php echo ($transaction['transaction_type'] === 'income' ? '+' : '-') . number_format($transaction['amount'], 2); ?> ₺
                        </td>
                        <td>
                            <?php 
                            $methods = [
                                'cash' => 'Nakit',
                                'bank_transfer' => 'Banka Havalesi',
                                'credit_card' => 'Kredi Kartı',
                                'check' => 'Çek'
                            ];
                            echo $methods[$transaction['payment_method']] ?? $transaction['payment_method'];
                            ?>
                        </td>
                        <td><?php echo htmlspecialchars($transaction['description']); ?></td>
                        <td><?php echo htmlspecialchars($transaction['created_by_name'] ?? 'Sistem'); ?></td>
                        <td>
                            <a href="?action=edit_transaction&id=<?php echo $transaction['id']; ?>" class="btn btn-sm btn-warning">
                                <i class="fas fa-edit"></i>
                            </a>
                            <a href="?action=delete_transaction&id=<?php echo $transaction['id']; ?>" 
                               class="btn btn-sm btn-danger" 
                               onclick="return confirm('Bu işlemi silmek istediğinizden emin misiniz?')">
                                <i class="fas fa-trash"></i>
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
<?php endif; ?>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
