<?php
$page_title = 'Veri Dışa Aktarma - BAŞKENT 1910 GÜCÜ SK';
require_once __DIR__ . '/../includes/header.php';

$action = $_GET['action'] ?? 'list';
$message = '';
$error = '';

// Excel export için basit CSV oluşturma fonksiyonu
function exportToCSV($data, $filename, $headers = []) {
    // Output buffer'ı temizle
    if (ob_get_level()) {
        ob_end_clean();
    }
    
    // Headers'ı ayarla
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename="' . $filename . '"');
    header('Cache-Control: no-cache, must-revalidate');
    header('Expires: Sat, 26 Jul 1997 05:00:00 GMT');
    
    // Output buffer başlat
    ob_start();
    
    $output = fopen('php://output', 'w');
    
    // BOM ekle (Excel'de Türkçe karakterler için)
    fprintf($output, chr(0xEF).chr(0xBB).chr(0xBF));
    
    // Başlıkları yaz
    if (!empty($headers)) {
        fputcsv($output, $headers);
    }
    
    // Verileri yaz
    foreach ($data as $row) {
        fputcsv($output, $row);
    }
    
    fclose($output);
    
    // Output buffer'ı gönder ve çık
    ob_end_flush();
    exit;
}

// Sporcu verilerini dışa aktarma
if ($action === 'export_athletes') {
    try {
        $athletes = $pdo->query("
            SELECT 
                a.first_name as 'Ad',
                a.last_name as 'Soyad',
                a.birth_date as 'Doğum Tarihi',
                a.age as 'Yaş',
                u.full_name as 'Veli Adı',
                u.phone as 'Veli Telefon',
                u.email as 'Veli Email',
                a.phone as 'Sporcu Telefon',
                a.address as 'Adres',
                a.emergency_contact as 'Acil Durum İletişim',
                a.registration_date as 'Kayıt Tarihi',
                a.status as 'Durum'
            FROM athletes a
            LEFT JOIN users u ON a.parent_id = u.id
            ORDER BY a.first_name, a.last_name
        ")->fetchAll(PDO::FETCH_ASSOC);
        
        $filename = 'sporcular_' . date('Y-m-d_H-i-s') . '.csv';
        exportToCSV($athletes, $filename);
    } catch (Exception $e) {
        $error = "Export hatası: " . $e->getMessage();
    }
}

// Alternatif export yöntemi - HTML tablo olarak
if ($action === 'export_athletes_html') {
    try {
        $athletes = $pdo->query("
            SELECT 
                a.first_name as 'Ad',
                a.last_name as 'Soyad',
                a.birth_date as 'Doğum Tarihi',
                a.age as 'Yaş',
                u.full_name as 'Veli Adı',
                u.phone as 'Veli Telefon',
                u.email as 'Veli Email',
                a.phone as 'Sporcu Telefon',
                a.address as 'Adres',
                a.emergency_contact as 'Acil Durum İletişim',
                a.registration_date as 'Kayıt Tarihi',
                a.status as 'Durum'
            FROM athletes a
            LEFT JOIN users u ON a.parent_id = u.id
            ORDER BY a.first_name, a.last_name
        ")->fetchAll(PDO::FETCH_ASSOC);
        
        $filename = 'sporcular_' . date('Y-m-d_H-i-s') . '.html';
        
        header('Content-Type: text/html; charset=utf-8');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        
        echo '<!DOCTYPE html>
        <html>
        <head>
            <meta charset="UTF-8">
            <title>Sporcu Listesi</title>
            <style>
                table { border-collapse: collapse; width: 100%; }
                th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
                th { background-color: #f2f2f2; }
            </style>
        </head>
        <body>
        <h1>Sporcu Listesi</h1>
        <table>
        <tr>';
        
        // Başlıkları yaz
        if (!empty($athletes)) {
            foreach (array_keys($athletes[0]) as $header) {
                echo '<th>' . htmlspecialchars($header) . '</th>';
            }
            echo '</tr>';
            
            // Verileri yaz
            foreach ($athletes as $row) {
                echo '<tr>';
                foreach ($row as $value) {
                    echo '<td>' . htmlspecialchars($value) . '</td>';
                }
                echo '</tr>';
            }
        }
        
        echo '</table>
        </body>
        </html>';
        exit;
        
    } catch (Exception $e) {
        $error = "Export hatası: " . $e->getMessage();
    }
}

// Aidat verilerini dışa aktarma
if ($action === 'export_payments') {
    $start_date = $_GET['start_date'] ?? date('Y-m-01');
    $end_date = $_GET['end_date'] ?? date('Y-m-t');
    
    $payments = $pdo->prepare("
        SELECT 
            a.first_name as 'Sporcu Adı',
            a.last_name as 'Sporcu Soyadı',
            p.amount as 'Tutar (TL)',
            p.payment_month as 'Ödeme Ayı',
            p.payment_date as 'Ödeme Tarihi',
            p.status as 'Durum',
            p.payment_method as 'Ödeme Yöntemi',
            p.notes as 'Notlar',
            p.created_at as 'Kayıt Tarihi'
        FROM payments p
        JOIN athletes a ON p.athlete_id = a.id
        WHERE p.payment_month BETWEEN ? AND ?
        ORDER BY p.payment_month DESC, a.first_name, a.last_name
    ");
    $payments->execute([$start_date, $end_date]);
    $payment_data = $payments->fetchAll(PDO::FETCH_ASSOC);
    
    $filename = 'aidatlar_' . $start_date . '_' . $end_date . '.csv';
    exportToCSV($payment_data, $filename);
}

// Yoklama verilerini dışa aktarma
if ($action === 'export_attendance') {
    $start_date = $_GET['start_date'] ?? date('Y-m-01');
    $end_date = $_GET['end_date'] ?? date('Y-m-t');
    
    $attendance = $pdo->prepare("
        SELECT 
            a.first_name as 'Sporcu Adı',
            a.last_name as 'Sporcu Soyadı',
            att.training_date as 'Antrenman Tarihi',
            att.status as 'Durum',
            att.notes as 'Notlar',
            att.created_at as 'Kayıt Tarihi'
        FROM attendance att
        JOIN athletes a ON att.athlete_id = a.id
        WHERE att.training_date BETWEEN ? AND ?
        ORDER BY att.training_date DESC, a.first_name, a.last_name
    ");
    $attendance->execute([$start_date, $end_date]);
    $attendance_data = $attendance->fetchAll(PDO::FETCH_ASSOC);
    
    $filename = 'yoklama_' . $start_date . '_' . $end_date . '.csv';
    exportToCSV($attendance_data, $filename);
}

// Antrenman programlarını dışa aktarma
if ($action === 'export_trainings') {
    $trainings = $pdo->query("
        SELECT 
            a.first_name as 'Sporcu Adı',
            a.last_name as 'Sporcu Soyadı',
            ts.day_of_week as 'Gün',
            ts.start_time as 'Başlangıç Saati',
            ts.end_time as 'Bitiş Saati',
            ts.location as 'Lokasyon',
            ts.coach_name as 'Antrenör',
            ts.notes as 'Notlar',
            ts.created_at as 'Oluşturma Tarihi'
        FROM training_schedules ts
        JOIN athletes a ON ts.athlete_id = a.id
        ORDER BY ts.day_of_week, ts.start_time, a.first_name, a.last_name
    ")->fetchAll(PDO::FETCH_ASSOC);
    
    $filename = 'antrenman_programlari_' . date('Y-m-d_H-i-s') . '.csv';
    exportToCSV($trainings, $filename);
}

// Velileri dışa aktarma
if ($action === 'export_parents') {
    $parents = $pdo->query("
        SELECT 
            u.full_name as 'Ad Soyad',
            u.username as 'Kullanıcı Adı',
            u.email as 'Email',
            u.phone as 'Telefon',
            COUNT(a.id) as 'Sporcu Sayısı',
            u.created_at as 'Kayıt Tarihi'
        FROM users u
        LEFT JOIN athletes a ON u.id = a.parent_id
        WHERE u.user_type = 'veli'
        GROUP BY u.id
        ORDER BY u.full_name
    ")->fetchAll(PDO::FETCH_ASSOC);
    
    $filename = 'veliler_' . date('Y-m-d_H-i-s') . '.csv';
    exportToCSV($parents, $filename);
}

// Genel rapor oluşturma
if ($action === 'export_report') {
    $report_type = $_GET['report_type'] ?? 'monthly';
    $month = $_GET['month'] ?? date('Y-m');
    
    $report_data = [];
    
    if ($report_type === 'monthly') {
        // Aylık genel rapor
        $stats = $pdo->prepare("
            SELECT 
                'Aktif Sporcu Sayısı' as 'Metrik',
                COUNT(*) as 'Değer'
            FROM athletes 
            WHERE status = 'active'
            
            UNION ALL
            
            SELECT 
                'Toplam Veli Sayısı' as 'Metrik',
                COUNT(*) as 'Değer'
            FROM users 
            WHERE user_type = 'veli'
            
            UNION ALL
            
            SELECT 
                'Bu Ay Ödenen Aidat' as 'Metrik',
                COUNT(*) as 'Değer'
            FROM payments 
            WHERE payment_month = ? AND status = 'paid'
            
            UNION ALL
            
            SELECT 
                'Bu Ay Yoklama Kaydı' as 'Metrik',
                COUNT(*) as 'Değer'
            FROM attendance 
            WHERE year = YEAR(?) AND month = MONTH(?)
        ");
        $stats->execute([$month, $month, $month]);
        $report_data = $stats->fetchAll(PDO::FETCH_ASSOC);
    }
    
    $filename = 'genel_rapor_' . $month . '.csv';
    exportToCSV($report_data, $filename);
}

// İstatistikler
$export_stats = [];
$stmt = $pdo->query("SELECT COUNT(*) as total FROM athletes WHERE status = 'active'");
$export_stats['athletes'] = $stmt->fetch()['total'];

$stmt = $pdo->query("SELECT COUNT(*) as total FROM users WHERE user_type = 'veli'");
$export_stats['parents'] = $stmt->fetch()['total'];

$stmt = $pdo->query("SELECT COUNT(*) as total FROM payments WHERE payment_month = DATE_FORMAT(NOW(), '%Y-%m')");
$export_stats['payments_this_month'] = $stmt->fetch()['total'];

$stmt = $pdo->query("SELECT COUNT(*) as total FROM attendance WHERE year = YEAR(NOW()) AND month = MONTH(NOW())");
$export_stats['attendance_this_month'] = $stmt->fetch()['total'];
?>

<div class="page-header">
    <div class="page-title">
        <i class="fas fa-download"></i>
        <h2>Veri Dışa Aktarma</h2>
    </div>
    <div class="header-actions">
        <a href="?action=export_report" class="btn btn-primary">
            <i class="fas fa-file-alt"></i>
            <span>Genel Rapor</span>
        </a>
    </div>
</div>

<?php if ($message): ?>
    <div class="alert alert-success">
        <i class="fas fa-check-circle"></i>
        <?php echo htmlspecialchars($message); ?>
    </div>
<?php endif; ?>

<?php if ($error): ?>
    <div class="alert alert-error">
        <i class="fas fa-exclamation-circle"></i>
        <?php echo htmlspecialchars($error); ?>
    </div>
<?php endif; ?>

<!-- İstatistik Kartları -->
<div class="export-stats">
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-users"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo $export_stats['athletes']; ?></h3>
                <p>Aktif Sporcu</p>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-user-friends"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo $export_stats['parents']; ?></h3>
                <p>Toplam Veli</p>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-credit-card"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo $export_stats['payments_this_month']; ?></h3>
                <p>Bu Ay Aidat</p>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-clipboard-check"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo $export_stats['attendance_this_month']; ?></h3>
                <p>Bu Ay Yoklama</p>
            </div>
        </div>
    </div>
</div>

<!-- Export Seçenekleri -->
<div class="export-options">
    <div class="export-grid">
        <!-- Sporcular -->
        <div class="export-card">
            <div class="export-header">
                <div class="export-icon">
                    <i class="fas fa-users"></i>
                </div>
                <div class="export-info">
                    <h3>Sporcu Verileri</h3>
                    <p>Tüm sporcu bilgilerini Excel formatında indirin</p>
                </div>
            </div>
            <div class="export-actions">
                <a href="?action=export_athletes" class="btn btn-primary">
                    <i class="fas fa-download"></i>
                    <span>CSV İndir</span>
                </a>
                <a href="?action=export_athletes_html" class="btn btn-secondary">
                    <i class="fas fa-file-alt"></i>
                    <span>HTML İndir</span>
                </a>
            </div>
        </div>
        
        <!-- Aidatlar -->
        <div class="export-card">
            <div class="export-header">
                <div class="export-icon">
                    <i class="fas fa-credit-card"></i>
                </div>
                <div class="export-info">
                    <h3>Aidat Raporu</h3>
                    <p>Belirli tarih aralığındaki aidat verilerini indirin</p>
                </div>
            </div>
            <div class="export-form">
                <form method="get" action="">
                    <input type="hidden" name="action" value="export_payments">
                    <div class="form-row">
                        <div class="form-group">
                            <label>Başlangıç Tarihi</label>
                            <input type="month" name="start_date" value="<?php echo date('Y-m-01'); ?>" required>
                        </div>
                        <div class="form-group">
                            <label>Bitiş Tarihi</label>
                            <input type="month" name="end_date" value="<?php echo date('Y-m-t'); ?>" required>
                        </div>
                    </div>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-download"></i>
                        <span>İndir</span>
                    </button>
                </form>
            </div>
        </div>
        
        <!-- Yoklama -->
        <div class="export-card">
            <div class="export-header">
                <div class="export-icon">
                    <i class="fas fa-clipboard-check"></i>
                </div>
                <div class="export-info">
                    <h3>Yoklama Raporu</h3>
                    <p>Belirli tarih aralığındaki yoklama verilerini indirin</p>
                </div>
            </div>
            <div class="export-form">
                <form method="get" action="">
                    <input type="hidden" name="action" value="export_attendance">
                    <div class="form-row">
                        <div class="form-group">
                            <label>Başlangıç Tarihi</label>
                            <input type="date" name="start_date" value="<?php echo date('Y-m-01'); ?>" required>
                        </div>
                        <div class="form-group">
                            <label>Bitiş Tarihi</label>
                            <input type="date" name="end_date" value="<?php echo date('Y-m-t'); ?>" required>
                        </div>
                    </div>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-download"></i>
                        <span>İndir</span>
                    </button>
                </form>
            </div>
        </div>
        
        <!-- Antrenman Programları -->
        <div class="export-card">
            <div class="export-header">
                <div class="export-icon">
                    <i class="fas fa-dumbbell"></i>
                </div>
                <div class="export-info">
                    <h3>Antrenman Programları</h3>
                    <p>Tüm antrenman programlarını Excel formatında indirin</p>
                </div>
            </div>
            <div class="export-actions">
                <a href="?action=export_trainings" class="btn btn-primary">
                    <i class="fas fa-download"></i>
                    <span>İndir</span>
                </a>
            </div>
        </div>
        
        <!-- Veliler -->
        <div class="export-card">
            <div class="export-header">
                <div class="export-icon">
                    <i class="fas fa-user-friends"></i>
                </div>
                <div class="export-info">
                    <h3>Veli Verileri</h3>
                    <p>Tüm veli bilgilerini Excel formatında indirin</p>
                </div>
            </div>
            <div class="export-actions">
                <a href="?action=export_parents" class="btn btn-primary">
                    <i class="fas fa-download"></i>
                    <span>İndir</span>
                </a>
            </div>
        </div>
        
        <!-- Genel Rapor -->
        <div class="export-card">
            <div class="export-header">
                <div class="export-icon">
                    <i class="fas fa-chart-bar"></i>
                </div>
                <div class="export-info">
                    <h3>Genel İstatistik Raporu</h3>
                    <p>Kulüp genel istatistiklerini Excel formatında indirin</p>
                </div>
            </div>
            <div class="export-form">
                <form method="get" action="">
                    <input type="hidden" name="action" value="export_report">
                    <div class="form-group">
                        <label>Rapor Ayı</label>
                        <input type="month" name="month" value="<?php echo date('Y-m'); ?>" required>
                    </div>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-download"></i>
                        <span>İndir</span>
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Export Geçmişi -->
<div class="export-history">
    <div class="history-header">
        <h3><i class="fas fa-history"></i> Son Dışa Aktarmalar</h3>
    </div>
    <div class="history-content">
        <div class="history-item">
            <div class="history-icon">
                <i class="fas fa-file-csv"></i>
            </div>
            <div class="history-info">
                <h4>CSV Format</h4>
                <p>Tüm dosyalar CSV formatında indirilir ve Excel'de açılabilir</p>
            </div>
        </div>
        
        <div class="history-item">
            <div class="history-icon">
                <i class="fas fa-language"></i>
            </div>
            <div class="history-info">
                <h4>Türkçe Karakter Desteği</h4>
                <p>Dosyalar UTF-8 BOM ile kodlanır, Türkçe karakterler doğru görünür</p>
            </div>
        </div>
        
        <div class="history-item">
            <div class="history-icon">
                <i class="fas fa-clock"></i>
            </div>
            <div class="history-info">
                <h4>Gerçek Zamanlı</h4>
                <p>Tüm veriler anlık olarak güncel durumlarıyla dışa aktarılır</p>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
