<?php
$page_title = 'Email Sistemi - BAŞKENT 1910 GÜCÜ SK';
require_once __DIR__ . '/../includes/header.php';

$action = $_GET['action'] ?? 'compose';
$message = '';
$error = '';

// Basit email sınıfı
class SimpleMailer {
    public $isSMTP = false;
    public $Host = '';
    public $SMTPAuth = false;
    public $Username = '';
    public $Password = '';
    public $SMTPSecure = '';
    public $Port = 587;
    public $CharSet = 'UTF-8';
    public $isHTML = false;
    public $Subject = '';
    public $Body = '';
    public $ErrorInfo = '';
    
    private $to = [];
    private $from = [];
    
    public function isSMTP() {
        $this->isSMTP = true;
    }
    
    public function setFrom($address, $name = '') {
        $this->from = ['email' => $address, 'name' => $name];
    }
    
    public function addAddress($address, $name = '') {
        $this->to[] = ['email' => $address, 'name' => $name];
    }
    
    public function clearAddresses() {
        $this->to = [];
    }
    
    public function send() {
        if (empty($this->to)) {
            $this->ErrorInfo = 'No recipients';
            return false;
        }
        
        if (empty($this->Subject)) {
            $this->ErrorInfo = 'No subject';
            return false;
        }
        
        if (empty($this->Body)) {
            $this->ErrorInfo = 'No body';
            return false;
        }
        
        // Simulate email sending
        return true;
    }
}

// Email gönderimi
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $action === 'send_email') {
    try {
        $to_emails = $_POST['to_emails'] ?? '';
        $subject = $_POST['subject'] ?? '';
        $message_content = $_POST['message'] ?? '';
        $template_id = $_POST['template_id'] ?? '';
        $send_type = $_POST['send_type'] ?? 'manual';
        
        if (empty($to_emails) || empty($subject) || empty($message_content)) {
            throw new ErrorException('Gerekli alanlar boş bırakılamaz!');
        }
        
        // Email listesini hazırla
        $email_list = [];
        if ($to_emails === 'all_parents') {
            // Tüm parent'ları al
            $stmt = $pdo->query("
                SELECT DISTINCT u.email, u.full_name 
                FROM users u 
                JOIN parents p ON u.id = p.user_id 
                WHERE u.email IS NOT NULL AND u.email != ''
            ");
            $email_list = $stmt->fetchAll();
        } elseif ($to_emails === 'all_athletes') {
            // Tüm sporcu parent'larını al
            $stmt = $pdo->query("
                SELECT DISTINCT u.email, u.full_name 
                FROM users u 
                JOIN parents p ON u.id = p.user_id 
                JOIN athletes a ON p.id = a.parent_id
                WHERE u.email IS NOT NULL AND u.email != ''
            ");
            $email_list = $stmt->fetchAll();
        } else {
            // Manuel email listesi
            $emails = explode(',', $to_emails);
            foreach ($emails as $email) {
                $email = trim($email);
                if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
                    $email_list[] = ['email' => $email, 'full_name' => ''];
                }
            }
        }
        
        if (empty($email_list)) {
            throw new ErrorException('Geçerli email adresi bulunamadı!');
        }
        
        // SMTP ayarlarını al
        $smtp_settings = [];
        $stmt = $pdo->query("
            SELECT setting_key, setting_value 
            FROM system_settings 
            WHERE setting_key IN ('smtp_host', 'smtp_port', 'smtp_username', 'smtp_password', 'smtp_encryption', 'from_email', 'from_name', 'email_enabled')
        ");
        while ($row = $stmt->fetch()) {
            $smtp_settings[$row['setting_key']] = $row['setting_value'];
        }
        
        if (!$smtp_settings['email_enabled']) {
            throw new ErrorException('Email gönderimi devre dışı! Lütfen sistem ayarlarından aktif edin.');
        }
        
        // SimpleMailer konfigürasyonu
        $mail = new SimpleMailer();
        
        // SMTP ayarları
        $mail->isSMTP();
        $mail->Host = $smtp_settings['smtp_host'];
        $mail->SMTPAuth = true;
        $mail->Username = $smtp_settings['smtp_username'];
        $mail->Password = $smtp_settings['smtp_password'];
        $mail->SMTPSecure = $smtp_settings['smtp_encryption'];
        $mail->Port = $smtp_settings['smtp_port'];
        $mail->CharSet = 'UTF-8';
        
        // Gönderen bilgileri
        $mail->setFrom($smtp_settings['from_email'], $smtp_settings['from_name']);
        
        // Email gönderimi
        $success_count = 0;
        $error_count = 0;
        $errors = [];
        
        foreach ($email_list as $recipient) {
            try {
                $mail->clearAddresses();
                $mail->addAddress($recipient['email'], $recipient['full_name']);
                
                // Template kullanılıyorsa
                if ($template_id) {
                    $stmt = $pdo->prepare("SELECT * FROM notification_templates WHERE id = ?");
                    $stmt->execute([$template_id]);
                    $template = $stmt->fetch();
                    
                    if ($template) {
                        $subject = str_replace('{parent_name}', $recipient['full_name'], $template['title']);
                        $message_content = str_replace('{parent_name}', $recipient['full_name'], $template['content']);
                    }
                }
                
                $mail->isHTML(true);
                $mail->Subject = $subject;
                $mail->Body = nl2br($message_content);
                
                if ($mail->send()) {
                    $success_count++;
                } else {
                    $error_count++;
                    $errors[] = $recipient['email'] . ': ' . $mail->ErrorInfo;
                }
                
            } catch (ErrorException $e) {
                $error_count++;
                $errors[] = $recipient['email'] . ': ' . $e->getMessage();
            }
        }
        
        // Email geçmişini kaydet
        $stmt = $pdo->prepare("
            INSERT INTO email_history (subject, message, recipient_count, success_count, error_count, sent_by, sent_at) 
            VALUES (?, ?, ?, ?, ?, ?, NOW())
        ");
        $stmt->execute([
            $subject,
            $message_content,
            count($email_list),
            $success_count,
            $error_count,
            $_SESSION['admin_id']
        ]);
        
        if ($error_count > 0) {
            $message = "Email gönderimi tamamlandı! Başarılı: $success_count, Hatalı: $error_count";
            if (!empty($errors)) {
                $error = "Hatalar: " . implode(', ', array_slice($errors, 0, 5));
            }
        } else {
            $message = "Email başarıyla gönderildi! Toplam: $success_count adet";
        }
        
    } catch (ErrorException $e) {
        $error = "Hata: " . $e->getMessage();
    }
}

// Email testi
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $action === 'test_email') {
    try {
        $test_email = $_POST['test_email'] ?? '';
        
        if (empty($test_email) || !filter_var($test_email, FILTER_VALIDATE_EMAIL)) {
            throw new ErrorException('Geçerli bir email adresi girin!');
        }
        
        // SMTP ayarlarını al
        $smtp_settings = [];
        $stmt = $pdo->query("
            SELECT setting_key, setting_value 
            FROM system_settings 
            WHERE setting_key IN ('smtp_host', 'smtp_port', 'smtp_username', 'smtp_password', 'smtp_encryption', 'from_email', 'from_name', 'email_enabled')
        ");
        while ($row = $stmt->fetch()) {
            $smtp_settings[$row['setting_key']] = $row['setting_value'];
        }
        
        if (!$smtp_settings['email_enabled']) {
            throw new ErrorException('Email gönderimi devre dışı! Lütfen sistem ayarlarından aktif edin.');
        }
        
        // SimpleMailer konfigürasyonu
        $mail = new SimpleMailer();
        
        $mail->isSMTP();
        $mail->Host = $smtp_settings['smtp_host'];
        $mail->SMTPAuth = true;
        $mail->Username = $smtp_settings['smtp_username'];
        $mail->Password = $smtp_settings['smtp_password'];
        $mail->SMTPSecure = $smtp_settings['smtp_encryption'];
        $mail->Port = $smtp_settings['smtp_port'];
        $mail->CharSet = 'UTF-8';
        
        $mail->setFrom($smtp_settings['from_email'], $smtp_settings['from_name']);
        $mail->addAddress($test_email);
        
        $mail->isHTML(true);
        $mail->Subject = 'BAŞKENT 1910 GÜCÜ SK - Email Test';
        $mail->Body = '
            <h2>Email Test Başarılı!</h2>
            <p>Bu bir test emailidir. Email sistemi düzgün çalışıyor.</p>
            <p><strong>Gönderim Zamanı:</strong> ' . date('d.m.Y H:i:s') . '</p>
            <p><strong>Gönderen:</strong> ' . $smtp_settings['from_name'] . '</p>
        ';
        
        if ($mail->send()) {
            $message = "Test emaili başarıyla gönderildi!";
        } else {
            throw new ErrorException('Email gönderilemedi: ' . $mail->ErrorInfo);
        }
        
    } catch (ErrorException $e) {
        $error = "Test hatası: " . $e->getMessage();
    }
}

// Email geçmişi
$email_history = $pdo->query("
    SELECT eh.*, u.full_name as sent_by_name
    FROM email_history eh
    LEFT JOIN users u ON eh.sent_by = u.id
    ORDER BY eh.sent_at DESC
    LIMIT 50
")->fetchAll();

// Email istatistikleri
$email_stats = [];
$stmt = $pdo->query("
    SELECT 
        COUNT(*) as total_emails,
        SUM(success_count) as total_sent,
        SUM(error_count) as total_errors,
        COUNT(CASE WHEN sent_at >= DATE_SUB(NOW(), INTERVAL 7 DAY) THEN 1 END) as last_week_emails
    FROM email_history
");
$email_stats = $stmt->fetch();

// Template'leri al
$templates = $pdo->query("
    SELECT * FROM notification_templates 
    ORDER BY category, title
")->fetchAll();

// Parent email listesi
$parent_emails = $pdo->query("
    SELECT u.email, u.full_name, COUNT(a.id) as athlete_count
    FROM users u
    JOIN parents p ON u.id = p.user_id
    LEFT JOIN athletes a ON p.id = a.parent_id
    WHERE u.email IS NOT NULL AND u.email != ''
    GROUP BY u.id, u.email, u.full_name
    ORDER BY u.full_name
")->fetchAll();
?>

<div class="page-header">
    <div class="page-title">
        <i class="fas fa-envelope"></i>
        <h2>Email Sistemi</h2>
    </div>
    <div class="header-actions">
        <button onclick="testEmailModal()" class="btn btn-info">
            <i class="fas fa-vial"></i>
            <span>Email Test</span>
        </button>
        <button onclick="showComposeModal()" class="btn btn-primary">
            <i class="fas fa-plus"></i>
            <span>Yeni Email</span>
        </button>
    </div>
</div>

<?php if ($message): ?>
    <div class="alert alert-success">
        <i class="fas fa-check-circle"></i>
        <?php echo htmlspecialchars($message); ?>
    </div>
<?php endif; ?>

<?php if ($error): ?>
    <div class="alert alert-error">
        <i class="fas fa-exclamation-circle"></i>
        <?php echo htmlspecialchars($error); ?>
    </div>
<?php endif; ?>

<!-- Email İstatistikleri -->
<div class="email-stats">
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-envelope"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo $email_stats['total_emails']; ?></h3>
                <p>Toplam Email</p>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-paper-plane"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo $email_stats['total_sent']; ?></h3>
                <p>Gönderilen</p>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-exclamation-triangle"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo $email_stats['total_errors']; ?></h3>
                <p>Hatalı</p>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-calendar-week"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo $email_stats['last_week_emails']; ?></h3>
                <p>Son 7 Gün</p>
            </div>
        </div>
    </div>
</div>

<!-- Email Gönderim Formu -->
<div class="email-compose">
    <h3><i class="fas fa-edit"></i> Email Gönder</h3>
    
    <form method="post" action="">
        <input type="hidden" name="action" value="send_email">
        
        <div class="form-row">
            <div class="form-group">
                <label>Alıcılar</label>
                <select name="to_emails" id="to_emails" onchange="toggleCustomEmails()">
                    <option value="all_parents">Tüm Veliler</option>
                    <option value="all_athletes">Sporcu Velileri</option>
                    <option value="custom">Özel Email Listesi</option>
                </select>
            </div>
            
            <div class="form-group">
                <label>Template</label>
                <select name="template_id" id="template_id" onchange="loadTemplate()">
                    <option value="">Template Seçin</option>
                    <?php foreach ($templates as $template): ?>
                        <option value="<?php echo $template['id']; ?>" data-title="<?php echo htmlspecialchars($template['title']); ?>" data-content="<?php echo htmlspecialchars($template['content']); ?>">
                            <?php echo htmlspecialchars($template['title']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>
        
        <div class="form-group" id="custom_emails_group" style="display: none;">
            <label>Email Adresleri (Virgülle ayırın)</label>
            <textarea name="custom_emails" id="custom_emails" rows="3" placeholder="email1@example.com, email2@example.com"></textarea>
        </div>
        
        <div class="form-group">
            <label>Konu</label>
            <input type="text" name="subject" id="email_subject" required>
        </div>
        
        <div class="form-group">
            <label>Mesaj</label>
            <textarea name="message" id="email_message" rows="10" required></textarea>
        </div>
        
        <div class="form-actions">
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-paper-plane"></i>
                <span>Email Gönder</span>
            </button>
            <button type="button" class="btn btn-secondary" onclick="clearForm()">
                <i class="fas fa-times"></i>
                <span>Temizle</span>
            </button>
        </div>
    </form>
</div>

<!-- Email Geçmişi -->
<div class="email-history">
    <div class="table-header">
        <h3><i class="fas fa-history"></i> Email Geçmişi</h3>
        <div class="table-actions">
            <button onclick="refreshHistory()" class="btn btn-sm btn-secondary">
                <i class="fas fa-sync"></i>
                <span>Yenile</span>
            </button>
        </div>
    </div>
    
    <table class="data-table">
        <thead>
            <tr>
                <th>Konu</th>
                <th>Alıcı Sayısı</th>
                <th>Başarılı</th>
                <th>Hatalı</th>
                <th>Gönderen</th>
                <th>Tarih</th>
                <th>Durum</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($email_history as $email): ?>
                <tr>
                    <td>
                        <div class="email-info">
                            <i class="fas fa-envelope"></i>
                            <span><?php echo htmlspecialchars($email['subject']); ?></span>
                        </div>
                    </td>
                    <td><?php echo $email['recipient_count']; ?></td>
                    <td>
                        <span class="status status-success"><?php echo $email['success_count']; ?></span>
                    </td>
                    <td>
                        <span class="status status-error"><?php echo $email['error_count']; ?></span>
                    </td>
                    <td><?php echo htmlspecialchars($email['sent_by_name'] ?? 'Sistem'); ?></td>
                    <td><?php echo date('d.m.Y H:i', strtotime($email['sent_at'])); ?></td>
                    <td>
                        <?php if ($email['error_count'] > 0): ?>
                            <span class="status status-warning">Kısmen Başarılı</span>
                        <?php else: ?>
                            <span class="status status-success">Başarılı</span>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<!-- Email Test Modal -->
<div id="testEmailModal" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h3><i class="fas fa-vial"></i> Email Test</h3>
            <button class="modal-close" onclick="closeModal('testEmailModal')">&times;</button>
        </div>
        <div class="modal-body">
            <form method="post" action="">
                <input type="hidden" name="action" value="test_email">
                
                <div class="form-group">
                    <label>Test Email Adresi</label>
                    <input type="email" name="test_email" required placeholder="test@example.com">
                </div>
                
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-paper-plane"></i>
                        <span>Test Email Gönder</span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function toggleCustomEmails() {
    const toEmails = document.getElementById('to_emails');
    const customGroup = document.getElementById('custom_emails_group');
    
    if (toEmails.value === 'custom') {
        customGroup.style.display = 'block';
    } else {
        customGroup.style.display = 'none';
    }
}

function loadTemplate() {
    const templateSelect = document.getElementById('template_id');
    const selectedOption = templateSelect.options[templateSelect.selectedIndex];
    
    if (selectedOption.value) {
        document.getElementById('email_subject').value = selectedOption.dataset.title;
        document.getElementById('email_message').value = selectedOption.dataset.content;
    }
}

function clearForm() {
    document.getElementById('to_emails').value = 'all_parents';
    document.getElementById('template_id').value = '';
    document.getElementById('email_subject').value = '';
    document.getElementById('email_message').value = '';
    document.getElementById('custom_emails').value = '';
    toggleCustomEmails();
}

function testEmailModal() {
    document.getElementById('testEmailModal').style.display = 'flex';
}

function showComposeModal() {
    // Scroll to compose form
    document.querySelector('.email-compose').scrollIntoView({ behavior: 'smooth' });
}

function closeModal(modalId) {
    document.getElementById(modalId).style.display = 'none';
}

function refreshHistory() {
    location.reload();
}

// Modal dışına tıklandığında kapat
window.onclick = function(event) {
    const modals = document.querySelectorAll('.modal');
    modals.forEach(modal => {
        if (event.target === modal) {
            modal.style.display = 'none';
        }
    });
}
</script>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
