<?php
$page_title = 'Aidat Yönetimi - BAŞKENT 1910 GÜCÜ SK';
require_once __DIR__ . '/../includes/header.php';

$action = $_GET['action'] ?? 'list';
$message = '';
$error = '';

// Aidat ekleme/düzenleme işlemleri
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $athlete_id = $_POST['athlete_id'] ?? '';
    $amount = $_POST['amount'] ?? '';
    $payment_month = $_POST['payment_month'] ?? '';
    $payment_date = $_POST['payment_date'] ?? '';
    $status = $_POST['status'] ?? 'pending';
    $payment_method = trim($_POST['payment_method'] ?? '');
    $notes = trim($_POST['notes'] ?? '');
    
    if ($athlete_id && $amount && $payment_month) {
        try {
            if ($action === 'add') {
                $stmt = $pdo->prepare("INSERT INTO payments (athlete_id, amount, payment_month, payment_date, status, payment_method, notes) VALUES (?, ?, ?, ?, ?, ?, ?)");
                $stmt->execute([$athlete_id, $amount, $payment_month, $payment_date ?: null, $status, $payment_method, $notes]);
                
                // Eğer aidat ödendiyse, kasa modülüne de gelir kaydı ekle
                if ($status === 'paid') {
                    $stmt = $pdo->prepare("
                        INSERT INTO cash_transactions 
                        (transaction_type, category, amount, description, payment_method, transaction_date, created_by) 
                        VALUES ('income', 'Aidat Ödemeleri', ?, ?, ?, ?, ?)
                    ");
                    $stmt->execute([
                        $amount,
                        "Sporcu aidat ödemesi - " . $payment_month,
                        $payment_method ?: 'cash',
                        $payment_date ?: date('Y-m-d'),
                        $_SESSION['admin_id']
                    ]);
                }
                
                $message = "Aidat kaydı eklendi!";
            } elseif ($action === 'edit' && isset($_GET['id'])) {
                // Önce eski kaydı al
                $stmt = $pdo->prepare("SELECT * FROM payments WHERE id = ?");
                $stmt->execute([$_GET['id']]);
                $old_payment = $stmt->fetch();
                
                $stmt = $pdo->prepare("UPDATE payments SET athlete_id=?, amount=?, payment_month=?, payment_date=?, status=?, payment_method=?, notes=? WHERE id=?");
                $stmt->execute([$athlete_id, $amount, $payment_month, $payment_date ?: null, $status, $payment_method, $notes, $_GET['id']]);
                
                // Eğer durum "ödendi" olarak değiştirildiyse veya güncellendiyse
                if ($status === 'paid') {
                    // Eski kasa kaydını sil (varsa)
                    if ($old_payment['status'] === 'paid') {
                        $stmt = $pdo->prepare("DELETE FROM cash_transactions WHERE description LIKE ? AND transaction_type = 'income' AND category = 'Aidat Ödemeleri'");
                        $stmt->execute(["%Sporcu aidat ödemesi - " . $old_payment['payment_month'] . "%"]);
                    }
                    
                    // Yeni kasa kaydı ekle
                    $stmt = $pdo->prepare("
                        INSERT INTO cash_transactions 
                        (transaction_type, category, amount, description, payment_method, transaction_date, created_by) 
                        VALUES ('income', 'Aidat Ödemeleri', ?, ?, ?, ?, ?)
                    ");
                    $stmt->execute([
                        $amount,
                        "Sporcu aidat ödemesi - " . $payment_month,
                        $payment_method ?: 'cash',
                        $payment_date ?: date('Y-m-d'),
                        $_SESSION['admin_id']
                    ]);
                } elseif ($old_payment['status'] === 'paid' && $status !== 'paid') {
                    // Eğer ödenmiş aidat beklemede veya gecikmiş yapıldıysa, kasa kaydını sil
                    $stmt = $pdo->prepare("DELETE FROM cash_transactions WHERE description LIKE ? AND transaction_type = 'income' AND category = 'Aidat Ödemeleri'");
                    $stmt->execute(["%Sporcu aidat ödemesi - " . $old_payment['payment_month'] . "%"]);
                }
                
                $message = "Aidat kaydı güncellendi!";
            }
        } catch (Exception $e) {
            $error = "Hata: " . $e->getMessage();
        }
    } else {
        $error = "Sporcu, tutar ve ay zorunludur!";
    }
}

// Aidat silme işlemi
if ($action === 'delete' && isset($_GET['id'])) {
    try {
        // Önce aidat bilgilerini al
        $stmt = $pdo->prepare("SELECT * FROM payments WHERE id = ?");
        $stmt->execute([$_GET['id']]);
        $payment = $stmt->fetch();
        
        // Eğer aidat ödenmişse, kasa kaydını da sil
        if ($payment && $payment['status'] === 'paid') {
            $stmt = $pdo->prepare("DELETE FROM cash_transactions WHERE description LIKE ? AND transaction_type = 'income' AND category = 'Aidat Ödemeleri'");
            $stmt->execute(["%Sporcu aidat ödemesi - " . $payment['payment_month'] . "%"]);
        }
        
        // Aidat kaydını sil
        $stmt = $pdo->prepare("DELETE FROM payments WHERE id = ?");
        $stmt->execute([$_GET['id']]);
        $message = "Aidat kaydı silindi!";
    } catch (Exception $e) {
        $error = "Hata: " . $e->getMessage();
    }
}

// Sporcu listesi (dropdown için)
$athletes = $pdo->query("SELECT id, first_name, last_name FROM athletes WHERE status = 'active' ORDER BY first_name, last_name")->fetchAll();

// Aidat listesi
$payments = $pdo->query("
    SELECT p.*, a.first_name, a.last_name 
    FROM payments p 
    JOIN athletes a ON p.athlete_id = a.id 
    ORDER BY p.payment_month DESC, a.first_name, a.last_name
")->fetchAll();

// Düzenleme için aidat bilgileri
$edit_payment = null;
if ($action === 'edit' && isset($_GET['id'])) {
    $stmt = $pdo->prepare("SELECT * FROM payments WHERE id = ?");
    $stmt->execute([$_GET['id']]);
    $edit_payment = $stmt->fetch();
}

// Bu ay için varsayılan değer
$current_month = date('Y-m');
$current_date = date('Y-m-d');
?>

<div class="page-header">
    <div class="page-title">
        <i class="fas fa-credit-card"></i>
        <h2>Aidat Yönetimi</h2>
    </div>
    <a href="?action=add" class="btn btn-primary">
        <i class="fas fa-plus"></i>
        <span>Yeni Aidat Kaydı</span>
    </a>
</div>

<?php if ($message): ?>
    <div class="alert alert-success">
        <i class="fas fa-check-circle"></i>
        <?php echo htmlspecialchars($message); ?>
    </div>
<?php endif; ?>

<?php if ($error): ?>
    <div class="alert alert-error">
        <i class="fas fa-exclamation-circle"></i>
        <?php echo htmlspecialchars($error); ?>
    </div>
<?php endif; ?>

<!-- Kasa Entegrasyonu Bilgisi -->
<div class="info-card">
    <div class="info-icon">
        <i class="fas fa-info-circle"></i>
    </div>
    <div class="info-content">
        <h4>Kasa Entegrasyonu</h4>
        <p>Ödendi olarak işaretlenen aidatlar otomatik olarak <strong>Kasa Yönetimi</strong> modülüne gelir kaydı olarak eklenir. Bu sayede hem aidat takibi hem de mali durum takibi aynı anda yapılır.</p>
    </div>
</div>

<?php if ($action === 'add' || $action === 'edit'): ?>
    <div class="form-container">
        <h3>
            <i class="fas fa-<?php echo $action === 'add' ? 'plus' : 'edit'; ?>"></i>
            <?php echo $action === 'add' ? 'Yeni Aidat Kaydı' : 'Aidat Kaydı Düzenle'; ?>
        </h3>
        
        <form method="post" action="">
            <div class="form-row">
                <div class="form-group">
                    <label>Sporcu *</label>
                    <select name="athlete_id" required>
                        <option value="">Sporcu Seçin</option>
                        <?php foreach ($athletes as $athlete): ?>
                            <option value="<?php echo $athlete['id']; ?>" <?php echo ($edit_payment['athlete_id'] ?? '') == $athlete['id'] ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($athlete['first_name'] . ' ' . $athlete['last_name']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label>Tutar (TL) *</label>
                    <input type="number" name="amount" step="0.01" min="0" value="<?php echo $edit_payment['amount'] ?? ''; ?>" required>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-group">
                    <label>Ödeme Ayı * (YYYY-MM)</label>
                    <input type="month" name="payment_month" value="<?php echo $edit_payment['payment_month'] ?? $current_month; ?>" required>
                </div>
                <div class="form-group">
                    <label>Ödeme Tarihi</label>
                    <input type="date" name="payment_date" value="<?php echo $edit_payment['payment_date'] ?? $current_date; ?>">
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-group">
                    <label>Durum *</label>
                    <select name="status" required>
                        <option value="pending" <?php echo ($edit_payment['status'] ?? '') == 'pending' ? 'selected' : ''; ?>>Beklemede</option>
                        <option value="paid" <?php echo ($edit_payment['status'] ?? '') == 'paid' ? 'selected' : ''; ?>>Ödendi</option>
                        <option value="overdue" <?php echo ($edit_payment['status'] ?? '') == 'overdue' ? 'selected' : ''; ?>>Gecikmiş</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>Ödeme Yöntemi</label>
                    <input type="text" name="payment_method" value="<?php echo htmlspecialchars($edit_payment['payment_method'] ?? ''); ?>" placeholder="Nakit, Kredi Kartı, Havale vb.">
                </div>
            </div>
            
            <div class="form-group">
                <label>Notlar</label>
                <textarea name="notes" rows="3"><?php echo htmlspecialchars($edit_payment['notes'] ?? ''); ?></textarea>
            </div>
            
            <div class="form-actions">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-<?php echo $action === 'add' ? 'plus' : 'save'; ?>"></i>
                    <span><?php echo $action === 'add' ? 'Ekle' : 'Güncelle'; ?></span>
                </button>
                <a href="?" class="btn btn-secondary">
                    <i class="fas fa-times"></i>
                    <span>İptal</span>
                </a>
            </div>
        </form>
    </div>
<?php else: ?>
    <div class="table-container">
        <table class="data-table">
            <thead>
                <tr>
                    <th>Sporcu</th>
                    <th>Ay</th>
                    <th>Tutar</th>
                    <th>Durum</th>
                    <th>Ödeme Tarihi</th>
                    <th>Yöntem</th>
                    <th>İşlemler</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($payments as $payment): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($payment['first_name'] . ' ' . $payment['last_name']); ?></td>
                        <td><?php echo date('m/Y', strtotime($payment['payment_month'] . '-01')); ?></td>
                        <td><?php echo number_format($payment['amount'], 2); ?> ₺</td>
                        <td>
                            <span class="status status-<?php echo $payment['status']; ?>">
                                <?php 
                                $status_text = [
                                    'pending' => 'Beklemede',
                                    'paid' => 'Ödendi',
                                    'overdue' => 'Gecikmiş'
                                ];
                                echo $status_text[$payment['status']] ?? $payment['status'];
                                ?>
                            </span>
                        </td>
                        <td><?php echo $payment['payment_date'] ? date('d.m.Y', strtotime($payment['payment_date'])) : '-'; ?></td>
                        <td><?php echo htmlspecialchars($payment['payment_method'] ?? '-'); ?></td>
                        <td>
                            <a href="?action=edit&id=<?php echo $payment['id']; ?>" class="btn btn-sm btn-secondary">
                                <i class="fas fa-edit"></i>
                                <span>Düzenle</span>
                            </a>
                            <a href="?action=delete&id=<?php echo $payment['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Emin misiniz?')">
                                <i class="fas fa-trash"></i>
                                <span>Sil</span>
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
<?php endif; ?>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>