<?php
$page_title = 'Push Notifications - BAŞKENT 1910 GÜCÜ SK';
require_once __DIR__ . '/../includes/header.php';

$action = $_GET['action'] ?? 'list';
$message = '';
$error = '';

// Bildirim şablonu ekleme/düzenleme
if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($action === 'add_template' || $action === 'edit_template')) {
    $template_name = trim($_POST['template_name'] ?? '');
    $title_template = trim($_POST['title_template'] ?? '');
    $message_template = trim($_POST['message_template'] ?? '');
    $category = $_POST['category'] ?? 'general';
    $is_active = isset($_POST['is_active']) ? 1 : 0;
    
    if ($template_name && $title_template && $message_template) {
        try {
            if ($action === 'add_template') {
                $stmt = $pdo->prepare("INSERT INTO notification_templates (template_name, title_template, message_template, category, is_active) VALUES (?, ?, ?, ?, ?)");
                $stmt->execute([$template_name, $title_template, $message_template, $category, $is_active]);
                $message = "Bildirim şablonu başarıyla eklendi!";
            } elseif ($action === 'edit_template' && isset($_GET['id'])) {
                $stmt = $pdo->prepare("UPDATE notification_templates SET template_name=?, title_template=?, message_template=?, category=?, is_active=? WHERE id=?");
                $stmt->execute([$template_name, $title_template, $message_template, $category, $is_active, $_GET['id']]);
                $message = "Bildirim şablonu güncellendi!";
            }
        } catch (Exception $e) {
            $error = "Hata: " . $e->getMessage();
        }
    } else {
        $error = "Şablon adı, başlık ve mesaj zorunludur!";
    }
}

// Toplu bildirim gönderme
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $action === 'send_bulk') {
    $template_id = $_POST['template_id'] ?? '';
    $target_type = $_POST['target_type'] ?? 'all';
    $target_users = $_POST['target_users'] ?? [];
    $custom_title = trim($_POST['custom_title'] ?? '');
    $custom_message = trim($_POST['custom_message'] ?? '');
    
    if (($template_id && $template_id !== 'custom') || ($template_id === 'custom' && $custom_title && $custom_message)) {
        try {
            // Hedef kullanıcıları belirle
            if ($target_type === 'all') {
                $target_users = $pdo->query("SELECT id FROM users WHERE user_type = 'veli'")->fetchAll(PDO::FETCH_COLUMN);
            }
            
            $title = $custom_title;
            $message_text = $custom_message;
            
            if ($template_id !== 'custom') {
                $stmt = $pdo->prepare("SELECT title_template, message_template FROM notification_templates WHERE id = ?");
                $stmt->execute([$template_id]);
                $template = $stmt->fetch();
                $title = $template['title_template'];
                $message_text = $template['message_template'];
            }
            
            // Bildirim kaydı oluştur
            $target_users_json = json_encode($target_users);
            $stmt = $pdo->prepare("INSERT INTO notifications (title, message, target_type, target_users, created_by) VALUES (?, ?, ?, ?, ?)");
            $stmt->execute([$title, $message_text, $target_type, $target_users_json, $_SESSION['admin_id']]);
            
            $message = "Toplu bildirim başarıyla oluşturuldu! (" . count($target_users) . " veliye gönderilecek)";
        } catch (Exception $e) {
            $error = "Hata: " . $e->getMessage();
        }
    } else {
        $error = "Lütfen geçerli bir şablon seçin veya özel mesaj yazın!";
    }
}

// Şablon silme
if ($action === 'delete_template' && isset($_GET['id'])) {
    try {
        $stmt = $pdo->prepare("DELETE FROM notification_templates WHERE id = ?");
        $stmt->execute([$_GET['id']]);
        $message = "Bildirim şablonu silindi!";
    } catch (Exception $e) {
        $error = "Hata: " . $e->getMessage();
    }
}

// Bildirim şablonları listesi
$templates = $pdo->query("SELECT * FROM notification_templates ORDER BY category, template_name")->fetchAll();

// Veli listesi
$parents = $pdo->query("SELECT id, full_name FROM users WHERE user_type = 'veli' ORDER BY full_name")->fetchAll();

// Düzenleme için şablon bilgileri
$edit_template = null;
if ($action === 'edit_template' && isset($_GET['id'])) {
    $stmt = $pdo->prepare("SELECT * FROM notification_templates WHERE id = ?");
    $stmt->execute([$_GET['id']]);
    $edit_template = $stmt->fetch();
}

// Kategori seçenekleri
$categories = [
    'general' => 'Genel',
    'payment' => 'Aidat',
    'training' => 'Antrenman',
    'attendance' => 'Yoklama',
    'urgent' => 'Acil'
];
?>

<div class="page-header">
    <div class="page-title">
        <i class="fas fa-bell"></i>
        <h2>Push Notifications</h2>
    </div>
    <div class="header-actions">
        <a href="?action=add_template" class="btn btn-primary">
            <i class="fas fa-plus"></i>
            <span>Şablon Ekle</span>
        </a>
        <a href="?action=send_bulk" class="btn btn-success">
            <i class="fas fa-paper-plane"></i>
            <span>Toplu Bildirim</span>
        </a>
    </div>
</div>

<?php if ($message): ?>
    <div class="alert alert-success">
        <i class="fas fa-check-circle"></i>
        <?php echo htmlspecialchars($message); ?>
    </div>
<?php endif; ?>

<?php if ($error): ?>
    <div class="alert alert-error">
        <i class="fas fa-exclamation-circle"></i>
        <?php echo htmlspecialchars($error); ?>
    </div>
<?php endif; ?>

<?php if ($action === 'add_template' || $action === 'edit_template'): ?>
    <div class="form-container">
        <h3>
            <i class="fas fa-<?php echo $action === 'add_template' ? 'plus' : 'edit'; ?>"></i>
            <?php echo $action === 'add_template' ? 'Yeni Bildirim Şablonu' : 'Şablon Düzenle'; ?>
        </h3>
        
        <form method="post" action="">
            <div class="form-row">
                <div class="form-group">
                    <label>Şablon Adı *</label>
                    <input type="text" name="template_name" 
                           value="<?php echo htmlspecialchars($edit_template['template_name'] ?? ''); ?>" 
                           required placeholder="Örn: Aidat Hatırlatması">
                </div>
                <div class="form-group">
                    <label>Kategori *</label>
                    <select name="category" required>
                        <?php foreach ($categories as $key => $label): ?>
                            <option value="<?php echo $key; ?>" 
                                    <?php echo ($edit_template['category'] ?? '') == $key ? 'selected' : ''; ?>>
                                <?php echo $label; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
            
            <div class="form-group">
                <label>Başlık Şablonu *</label>
                <input type="text" name="title_template" 
                       value="<?php echo htmlspecialchars($edit_template['title_template'] ?? ''); ?>" 
                       required placeholder="Örn: Aidat Ödemesi">
                <small class="form-help">Kullanılabilir değişkenler: {parent_name}, {athlete_name}, {amount}, {date}, {status}</small>
            </div>
            
            <div class="form-group">
                <label>Mesaj Şablonu *</label>
                <textarea name="message_template" rows="4" required 
                          placeholder="Örn: Sayın {parent_name}, {athlete_name} için {amount} TL aidat ödemesi beklenmektedir."><?php echo htmlspecialchars($edit_template['message_template'] ?? ''); ?></textarea>
                <small class="form-help">Kullanılabilir değişkenler: {parent_name}, {athlete_name}, {amount}, {date}, {status}, {message}</small>
            </div>
            
            <div class="form-group">
                <label class="checkbox-label">
                    <input type="checkbox" name="is_active" 
                           <?php echo ($edit_template['is_active'] ?? 1) ? 'checked' : ''; ?>>
                    <span>Şablon Aktif</span>
                </label>
            </div>
            
            <div class="form-actions">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-<?php echo $action === 'add_template' ? 'plus' : 'save'; ?>"></i>
                    <span><?php echo $action === 'add_template' ? 'Ekle' : 'Güncelle'; ?></span>
                </button>
                <a href="?" class="btn btn-secondary">
                    <i class="fas fa-times"></i>
                    <span>İptal</span>
                </a>
            </div>
        </form>
    </div>

<?php elseif ($action === 'send_bulk'): ?>
    <div class="form-container">
        <h3>
            <i class="fas fa-paper-plane"></i>
            Toplu Bildirim Gönder
        </h3>
        
        <form method="post" action="">
            <div class="form-group">
                <label>Bildirim Şablonu</label>
                <select name="template_id" id="template_select" onchange="toggleCustomMessage()">
                    <option value="">Şablon Seçin</option>
                    <?php foreach ($templates as $template): ?>
                        <option value="<?php echo $template['id']; ?>">
                            <?php echo htmlspecialchars($template['template_name']); ?> 
                            (<?php echo $categories[$template['category']]; ?>)
                        </option>
                    <?php endforeach; ?>
                    <option value="custom">Özel Mesaj</option>
                </select>
            </div>
            
            <div id="custom_message_fields" style="display: none;">
                <div class="form-group">
                    <label>Özel Başlık</label>
                    <input type="text" name="custom_title" placeholder="Bildirim başlığı">
                </div>
                <div class="form-group">
                    <label>Özel Mesaj</label>
                    <textarea name="custom_message" rows="4" placeholder="Bildirim mesajı"></textarea>
                </div>
            </div>
            
            <div class="form-group">
                <label>Hedef Kitle</label>
                <select name="target_type" id="target_type" onchange="toggleUserSelection()">
                    <option value="all">Tüm Veliler</option>
                    <option value="specific">Belirli Veliler</option>
                </select>
            </div>
            
            <div class="form-group" id="user_selection" style="display: none;">
                <label>Veli Seçimi</label>
                <div class="checkbox-group">
                    <?php foreach ($parents as $parent): ?>
                        <label class="checkbox-label">
                            <input type="checkbox" name="target_users[]" value="<?php echo $parent['id']; ?>">
                            <?php echo htmlspecialchars($parent['full_name']); ?>
                        </label>
                    <?php endforeach; ?>
                </div>
            </div>
            
            <div class="form-actions">
                <button type="submit" class="btn btn-success">
                    <i class="fas fa-paper-plane"></i>
                    <span>Bildirim Gönder</span>
                </button>
                <a href="?" class="btn btn-secondary">
                    <i class="fas fa-times"></i>
                    <span>İptal</span>
                </a>
            </div>
        </form>
    </div>

<?php else: ?>
    <div class="templates-grid">
        <?php foreach ($templates as $template): ?>
            <div class="template-card">
                <div class="template-header">
                    <div class="template-info">
                        <h4><?php echo htmlspecialchars($template['template_name']); ?></h4>
                        <span class="template-category category-<?php echo $template['category']; ?>">
                            <?php echo $categories[$template['category']]; ?>
                        </span>
                    </div>
                    <div class="template-actions">
                        <a href="?action=edit_template&id=<?php echo $template['id']; ?>" class="btn btn-sm btn-secondary">
                            <i class="fas fa-edit"></i>
                        </a>
                        <a href="?action=delete_template&id=<?php echo $template['id']; ?>" 
                           class="btn btn-sm btn-danger" 
                           onclick="return confirm('Emin misiniz?')">
                            <i class="fas fa-trash"></i>
                        </a>
                    </div>
                </div>
                <div class="template-content">
                    <div class="template-preview">
                        <strong>Başlık:</strong> <?php echo htmlspecialchars($template['title_template']); ?>
                    </div>
                    <div class="template-preview">
                        <strong>Mesaj:</strong> <?php echo htmlspecialchars(substr($template['message_template'], 0, 100)) . (strlen($template['message_template']) > 100 ? '...' : ''); ?>
                    </div>
                </div>
                <div class="template-status">
                    <span class="status <?php echo $template['is_active'] ? 'active' : 'inactive'; ?>">
                        <i class="fas fa-circle"></i>
                        <?php echo $template['is_active'] ? 'Aktif' : 'Pasif'; ?>
                    </span>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>

<script>
function toggleUserSelection() {
    const targetType = document.getElementById('target_type').value;
    const userSelection = document.getElementById('user_selection');
    
    if (targetType === 'specific') {
        userSelection.style.display = 'block';
    } else {
        userSelection.style.display = 'none';
    }
}

function toggleCustomMessage() {
    const templateSelect = document.getElementById('template_select').value;
    const customFields = document.getElementById('custom_message_fields');
    
    if (templateSelect === 'custom') {
        customFields.style.display = 'block';
    } else {
        customFields.style.display = 'none';
    }
}
</script>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
