<?php
// Lesson Notes endpoints

// Authentication gerekli
$payload = authenticate();
$parent_id = $payload['parent_id'];

// RESTful yapı: action path'ten alınıyor (/api/v1/lesson-notes/list)
// Eğer path'te action yoksa, GET parametresinden al (geriye dönük uyumluluk)
$action = $action ?? $_GET['action'] ?? '';

switch ($request_method) {
    case 'GET':
        // GET için varsayılan action list
        if (empty($action)) {
            $action = 'list';
        }
        
        switch ($action) {
            case 'list':
                // Ders notlarını listele
                $limit = $_GET['limit'] ?? 50;
                $offset = $_GET['offset'] ?? 0;
                $category = $_GET['category'] ?? '';
                $search = $_GET['search'] ?? '';
                
                $where_conditions = ["is_published = 1"];
                $params = [];
                
                if ($category) {
                    $where_conditions[] = "category = ?";
                    $params[] = $category;
                }
                
                if ($search) {
                    $where_conditions[] = "(title LIKE ? OR content LIKE ?)";
                    $params[] = "%$search%";
                    $params[] = "%$search%";
                }
                
                $params[] = (int)$limit;
                $params[] = (int)$offset;
                
                $stmt = $pdo->prepare("
                    SELECT 
                        id,
                        title,
                        SUBSTRING(content, 1, 200) as short_content,
                        category,
                        author,
                        priority,
                        tags,
                        created_at,
                        updated_at
                    FROM lesson_notes
                    WHERE " . implode(' AND ', $where_conditions) . "
                    ORDER BY created_at DESC
                    LIMIT ? OFFSET ?
                ");
                
                // PDO bindValue ile integer olarak bind et
                foreach ($params as $index => $param) {
                    if ($index >= count($params) - 2) {
                        // Son 2 parametre LIMIT ve OFFSET - integer olarak bind et
                        $stmt->bindValue($index + 1, (int)$param, PDO::PARAM_INT);
                    } else {
                        $stmt->bindValue($index + 1, $param);
                    }
                }
                $stmt->execute();
                $notes = $stmt->fetchAll();
                
                // Her not için formatla
                foreach ($notes as &$note) {
                    $note['tags_array'] = !empty($note['tags']) ? array_map('trim', explode(',', $note['tags'])) : [];
                    $note['formatted_date'] = date('d.m.Y', strtotime($note['created_at']));
                }
                
                api_response($notes, 200, 'Ders notları başarıyla getirildi');
                break;
                
            case 'detail':
                // Belirli bir ders notu detayı
                $note_id = $_GET['id'] ?? '';
                
                if (!$note_id) {
                    api_error('Ders notu ID gerekli', 400);
                }
                
                $stmt = $pdo->prepare("
                    SELECT *
                    FROM lesson_notes
                    WHERE id = ? AND is_published = 1
                ");
                $stmt->execute([$note_id]);
                $note = $stmt->fetch();
                
                if (!$note) {
                    api_error('Ders notu bulunamadı', 404);
                }
                
                $note['tags_array'] = !empty($note['tags']) ? array_map('trim', explode(',', $note['tags'])) : [];
                $note['formatted_date'] = date('d.m.Y H:i', strtotime($note['created_at']));
                
                api_response($note, 200, 'Ders notu detayları başarıyla getirildi');
                break;
                
            default:
                api_error('Geçersiz işlem', 400);
        }
        break;
        
    default:
        api_error('Desteklenmeyen HTTP metodu', 405);
}
?>
