<?php
// Notifications endpoints

// Authentication gerekli
$payload = authenticate();
$parent_id = $payload['parent_id'];

// RESTful yapı: action path'ten alınıyor (/api/v1/notifications/list)
// Eğer path'te action yoksa, GET parametresinden al (geriye dönük uyumluluk)
$action = $action ?? $_GET['action'] ?? '';

switch ($request_method) {
    case 'GET':
        // GET için varsayılan action list
        if (empty($action)) {
            $action = 'list';
        }
        
        switch ($action) {
            case 'list':
                // Parent'a gönderilen bildirimleri listele
                $limit = $_GET['limit'] ?? 50;
                $offset = $_GET['offset'] ?? 0;
                $status = $_GET['status'] ?? '';
                $type = $_GET['type'] ?? '';
                
                // Notifications tablosunda parent_id yoksa target_users JSON'dan kontrol et
                $where_conditions = [];
                $params = [];
                
                // parent_id kolonu varsa kullan, yoksa target_users JSON'dan kontrol et
                try {
                    $test_stmt = $pdo->query("SHOW COLUMNS FROM notifications LIKE 'parent_id'");
                    if ($test_stmt->rowCount() > 0) {
                        $where_conditions[] = "n.parent_id = ?";
                        $params[] = $parent_id;
                    } else {
                        // parent_id yoksa target_users JSON'dan kontrol et
                        $where_conditions[] = "(n.target_type = 'all' OR JSON_CONTAINS(n.target_users, CAST(? AS JSON)))";
                        $params[] = json_encode([$parent_id]);
                    }
                } catch (PDOException $e) {
                    // Varsayılan olarak target_users kullan
                    $where_conditions[] = "(n.target_type = 'all' OR JSON_CONTAINS(n.target_users, CAST(? AS JSON)))";
                    $params[] = json_encode([$parent_id]);
                }
                
                if ($status) {
                    $where_conditions[] = "n.status = ?";
                    $params[] = $status;
                }
                
                if ($type) {
                    $where_conditions[] = "n.type = ?";
                    $params[] = $type;
                }
                
                $params[] = (int)$limit;
                $params[] = (int)$offset;
                
                $stmt = $pdo->prepare("
                    SELECT 
                        n.id,
                        n.title,
                        n.message,
                        n.type,
                        n.status,
                        n.sent_at,
                        n.read_at,
                        n.created_at
                    FROM notifications n
                    WHERE " . implode(' AND ', $where_conditions) . "
                    ORDER BY n.sent_at DESC, n.created_at DESC
                    LIMIT ? OFFSET ?
                ");
                
                // PDO bindValue ile integer olarak bind et
                foreach ($params as $index => $param) {
                    if ($index >= count($params) - 2) {
                        // Son 2 parametre LIMIT ve OFFSET - integer olarak bind et
                        $stmt->bindValue($index + 1, (int)$param, PDO::PARAM_INT);
                    } else {
                        $stmt->bindValue($index + 1, $param);
                    }
                }
                $stmt->execute();
                $notifications = $stmt->fetchAll();
                
                // Her bildirim için ek bilgiler
                foreach ($notifications as &$notification) {
                    $notification['is_read'] = !is_null($notification['read_at']);
                    $notification['formatted_sent_at'] = $notification['sent_at'] ? 
                        date('d.m.Y H:i', strtotime($notification['sent_at'])) : null;
                    $notification['formatted_read_at'] = $notification['read_at'] ? 
                        date('d.m.Y H:i', strtotime($notification['read_at'])) : null;
                    $notification['type_text'] = $notification['type'] === 'payment' ? 'Ödeme' : 
                                               ($notification['type'] === 'training' ? 'Antrenman' : 
                                               ($notification['type'] === 'attendance' ? 'Yoklama' : 
                                               ($notification['type'] === 'urgent' ? 'Acil' : 'Genel')));
                    $notification['status_text'] = $notification['status'] === 'sent' ? 'Gönderildi' : 
                                                 ($notification['status'] === 'delivered' ? 'Teslim Edildi' : 'Hata');
                }
                
                api_response($notifications, 200, 'Bildirimler başarıyla getirildi');
                break;
                
            case 'unread':
                // Okunmamış bildirimler
                $limit = $_GET['limit'] ?? 20;
                
                // parent_id kontrolü
                $where_conditions_unread = [];
                $params_unread = [];
                
                try {
                    $test_stmt = $pdo->query("SHOW COLUMNS FROM notifications LIKE 'parent_id'");
                    if ($test_stmt->rowCount() > 0) {
                        $where_conditions_unread[] = "n.parent_id = ?";
                        $params_unread[] = $parent_id;
                    } else {
                        $where_conditions_unread[] = "(n.target_type = 'all' OR JSON_CONTAINS(n.target_users, CAST(? AS JSON)))";
                        $params_unread[] = json_encode([$parent_id]);
                    }
                } catch (PDOException $e) {
                    $where_conditions_unread[] = "(n.target_type = 'all' OR JSON_CONTAINS(n.target_users, CAST(? AS JSON)))";
                    $params_unread[] = json_encode([$parent_id]);
                }
                
                $where_conditions_unread[] = "n.read_at IS NULL";
                
                // status kolonu varsa kontrol et
                try {
                    $test_stmt = $pdo->query("SHOW COLUMNS FROM notifications LIKE 'status'");
                    if ($test_stmt->rowCount() > 0) {
                        $where_conditions_unread[] = "n.status = 'sent'";
                    }
                } catch (PDOException $e) {
                    // status kolonu yoksa atla
                }
                
                $params_unread[] = (int)$limit;
                
                $stmt = $pdo->prepare("
                    SELECT 
                        n.id,
                        n.title,
                        n.message,
                        COALESCE(n.type, 'general') as type,
                        n.sent_at,
                        n.created_at
                    FROM notifications n
                    WHERE " . implode(' AND ', $where_conditions_unread) . "
                    ORDER BY n.sent_at DESC, n.created_at DESC
                    LIMIT ?
                ");
                
                // PDO bindValue ile integer olarak bind et
                foreach ($params_unread as $index => $param) {
                    if ($index === count($params_unread) - 1) {
                        // Son parametre LIMIT - integer olarak bind et
                        $stmt->bindValue($index + 1, (int)$param, PDO::PARAM_INT);
                    } else {
                        $stmt->bindValue($index + 1, $param);
                    }
                }
                $stmt->execute();
                $notifications = $stmt->fetchAll();
                
                foreach ($notifications as &$notification) {
                    $notification['formatted_sent_at'] = $notification['sent_at'] ? 
                        date('d.m.Y H:i', strtotime($notification['sent_at'])) : null;
                    $notification['type_text'] = $notification['type'] === 'payment' ? 'Ödeme' : 
                                               ($notification['type'] === 'training' ? 'Antrenman' : 
                                               ($notification['type'] === 'attendance' ? 'Yoklama' : 
                                               ($notification['type'] === 'urgent' ? 'Acil' : 'Genel')));
                }
                
                api_response($notifications, 200, 'Okunmamış bildirimler başarıyla getirildi');
                break;
                
            case 'count':
                // Okunmamış bildirim sayısı
                // parent_id kontrolü
                $where_conditions_count = [];
                $params_count = [];
                
                try {
                    $test_stmt = $pdo->query("SHOW COLUMNS FROM notifications LIKE 'parent_id'");
                    if ($test_stmt->rowCount() > 0) {
                        $where_conditions_count[] = "parent_id = ?";
                        $params_count[] = $parent_id;
                    } else {
                        $where_conditions_count[] = "(target_type = 'all' OR JSON_CONTAINS(target_users, CAST(? AS JSON)))";
                        $params_count[] = json_encode([$parent_id]);
                    }
                } catch (PDOException $e) {
                    $where_conditions_count[] = "(target_type = 'all' OR JSON_CONTAINS(target_users, CAST(? AS JSON)))";
                    $params_count[] = json_encode([$parent_id]);
                }
                
                $where_conditions_count[] = "read_at IS NULL";
                
                // status kolonu varsa kontrol et
                try {
                    $test_stmt = $pdo->query("SHOW COLUMNS FROM notifications LIKE 'status'");
                    if ($test_stmt->rowCount() > 0) {
                        $where_conditions_count[] = "status = 'sent'";
                    }
                } catch (PDOException $e) {
                    // status kolonu yoksa atla
                }
                
                $stmt = $pdo->prepare("
                    SELECT COUNT(*) as unread_count
                    FROM notifications 
                    WHERE " . implode(' AND ', $where_conditions_count) . "
                ");
                $stmt->execute($params_count);
                $result = $stmt->fetch();
                
                api_response(['unread_count' => (int)$result['unread_count']], 200, 'Okunmamış bildirim sayısı başarıyla getirildi');
                break;
                
            case 'detail':
                // Belirli bir bildirim detayı
                $notification_id = $_GET['id'] ?? '';
                
                if (!$notification_id) {
                    api_error('Bildirim ID gerekli', 400);
                }
                
                $stmt = $pdo->prepare("
                    SELECT 
                        n.*
                    FROM notifications n
                    WHERE n.id = ? AND n.parent_id = ?
                ");
                $stmt->execute([$notification_id, $parent_id]);
                $notification = $stmt->fetch();
                
                if (!$notification) {
                    api_error('Bildirim bulunamadı', 404);
                }
                
                $notification['is_read'] = !is_null($notification['read_at']);
                $notification['formatted_sent_at'] = $notification['sent_at'] ? 
                    date('d.m.Y H:i', strtotime($notification['sent_at'])) : null;
                $notification['formatted_read_at'] = $notification['read_at'] ? 
                    date('d.m.Y H:i', strtotime($notification['read_at'])) : null;
                $notification['type_text'] = $notification['type'] === 'payment' ? 'Ödeme' : 
                                           ($notification['type'] === 'training' ? 'Antrenman' : 
                                           ($notification['type'] === 'attendance' ? 'Yoklama' : 
                                           ($notification['type'] === 'urgent' ? 'Acil' : 'Genel')));
                $notification['status_text'] = $notification['status'] === 'sent' ? 'Gönderildi' : 
                                             ($notification['status'] === 'delivered' ? 'Teslim Edildi' : 'Hata');
                
                api_response($notification, 200, 'Bildirim detayları başarıyla getirildi');
                break;
                
            default:
                api_error('Geçersiz işlem', 400);
        }
        break;
        
    case 'PUT':
        // PUT için varsayılan action read
        if (empty($action)) {
            $action = 'read';
        }
        
        switch ($action) {
            case 'read':
                // Bildirimi okundu olarak işaretle
                // RESTful: /api/v1/notifications/read?id=123
                // Veya GET parametresinden: ?id=123
                $notification_id = $_GET['id'] ?? '';
                
                if (!$notification_id) {
                    api_error('Bildirim ID gerekli', 400);
                }
                
                $stmt = $pdo->prepare("
                    UPDATE notifications 
                    SET read_at = NOW() 
                    WHERE id = ? AND parent_id = ? AND read_at IS NULL
                ");
                $stmt->execute([$notification_id, $parent_id]);
                
                if ($stmt->rowCount() === 0) {
                    api_error('Bildirim bulunamadı veya zaten okunmuş', 404);
                }
                
                api_response(null, 200, 'Bildirim okundu olarak işaretlendi');
                break;
                
            case 'read_all':
                // Tüm bildirimleri okundu olarak işaretle
                $stmt = $pdo->prepare("
                    UPDATE notifications 
                    SET read_at = NOW() 
                    WHERE parent_id = ? AND read_at IS NULL
                ");
                $stmt->execute([$parent_id]);
                
                $updated_count = $stmt->rowCount();
                
                api_response(['updated_count' => $updated_count], 200, "$updated_count bildirim okundu olarak işaretlendi");
                break;
                
            default:
                api_error('Geçersiz işlem', 400);
        }
        break;
        
    case 'DELETE':
        // Bildirimi sil
        $notification_id = $_GET['id'] ?? '';
        
        if (!$notification_id) {
            api_error('Bildirim ID gerekli', 400);
        }
        
        $stmt = $pdo->prepare("
            DELETE FROM notifications 
            WHERE id = ? AND parent_id = ?
        ");
        $stmt->execute([$notification_id, $parent_id]);
        
        if ($stmt->rowCount() === 0) {
            api_error('Bildirim bulunamadı', 404);
        }
        
        api_response(null, 200, 'Bildirim başarıyla silindi');
        break;
        
    default:
        api_error('Desteklenmeyen HTTP metodu', 405);
}
?>
