<?php
// Payments endpoints

// Authentication gerekli
$payload = authenticate();
$parent_id = $payload['parent_id']; // parents.id
$user_id = $payload['user_id']; // users.id

// NOT: Admin panel athletes.parent_id'ye users.id yazıyor

// RESTful yapı: action path'ten alınıyor (/api/v1/payments/list)
// Eğer path'te action yoksa, GET parametresinden al (geriye dönük uyumluluk)
$action = $action ?? $_GET['action'] ?? '';

switch ($request_method) {
    case 'GET':
        // GET için varsayılan action list
        if (empty($action)) {
            $action = 'list';
        }
        
        switch ($action) {
                case 'list':
                    // Parent'ın user_id'sini al (parents tablosundan)
                    $stmt = $pdo->prepare("SELECT user_id FROM parents WHERE id = ?");
                    $stmt->execute([$parent_id]);
                    $parent_record = $stmt->fetch();
                    
                    if ($parent_record) {
                        $user_id = $parent_record['user_id'];
                    } else {
                        // Eski sistem uyumluluğu: parent_id direkt user_id olabilir
                        $user_id = $parent_id;
                    }
                    
                    // Parent'ın sporcularının ödeme bilgilerini listele
                    // Hem parents.id hem de users.id (eski sistem) kontrolü yap
                    $athlete_id = $_GET['athlete_id'] ?? '';
                    $status = $_GET['status'] ?? '';
                    $year = $_GET['year'] ?? date('Y');
                    $month = $_GET['month'] ?? '';
                    
                    $where_conditions = ["(a.parent_id = ? OR a.parent_id = ?)"];
                    $params = [$parent_id, $user_id];
                
                if ($athlete_id) {
                    $where_conditions[] = "p.athlete_id = ?";
                    $params[] = $athlete_id;
                }
                
                if ($status) {
                    $where_conditions[] = "p.status = ?";
                    $params[] = $status;
                }
                
                if ($year) {
                    $where_conditions[] = "YEAR(p.payment_date) = ?";
                    $params[] = $year;
                }
                
                if ($month) {
                    $where_conditions[] = "MONTH(p.payment_date) = ?";
                    $params[] = $month;
                }
                
                $stmt = $pdo->prepare("
                    SELECT 
                        p.id,
                        p.amount,
                        p.payment_date,
                        p.status,
                        p.notes,
                        p.created_at,
                        p.updated_at,
                        a.first_name,
                        a.last_name,
                        a.id as athlete_id
                    FROM payments p
                    JOIN athletes a ON p.athlete_id = a.id
                    WHERE " . implode(' AND ', $where_conditions) . "
                    ORDER BY p.payment_date DESC, p.created_at DESC
                ");
                $stmt->execute($params);
                $payments = $stmt->fetchAll();
                
                // Her ödeme için ek bilgiler
                foreach ($payments as &$payment) {
                    $payment['athlete_name'] = $payment['first_name'] . ' ' . $payment['last_name'];
                    $payment['formatted_amount'] = number_format($payment['amount'], 2) . ' ₺';
                    $payment['formatted_date'] = date('d.m.Y', strtotime($payment['payment_date']));
                    $payment['status_text'] = $payment['status'] === 'paid' ? 'Ödendi' : 
                                            ($payment['status'] === 'pending' ? 'Bekliyor' : 'Gecikmiş');
                }
                
                api_response($payments, 200, 'Ödeme bilgileri başarıyla getirildi');
                break;
                
            case 'summary':
                // Parent'ın user_id'sini al (parents tablosundan)
                $stmt = $pdo->prepare("SELECT user_id FROM parents WHERE id = ?");
                $stmt->execute([$parent_id]);
                $parent_record = $stmt->fetch();
                
                if ($parent_record) {
                    $user_id = $parent_record['user_id'];
                } else {
                    // Eski sistem uyumluluğu: parent_id direkt user_id olabilir
                    $user_id = $parent_id;
                }
                
                // Ödeme özeti
                // Hem parents.id hem de users.id (eski sistem) kontrolü yap
                $athlete_id = $_GET['athlete_id'] ?? '';
                $year = $_GET['year'] ?? date('Y');
                
                $where_conditions = ["(a.parent_id = ? OR a.parent_id = ?)"];
                $params = [$parent_id, $user_id];
                
                if ($athlete_id) {
                    $where_conditions[] = "p.athlete_id = ?";
                    $params[] = $athlete_id;
                }
                
                if ($year) {
                    $where_conditions[] = "YEAR(p.payment_date) = ?";
                    $params[] = $year;
                }
                
                // Toplam ödeme istatistikleri
                $stmt = $pdo->prepare("
                    SELECT 
                        COUNT(*) as total_payments,
                        SUM(p.amount) as total_amount,
                        SUM(CASE WHEN p.status = 'paid' THEN p.amount ELSE 0 END) as paid_amount,
                        SUM(CASE WHEN p.status = 'pending' THEN p.amount ELSE 0 END) as pending_amount,
                        SUM(CASE WHEN p.status = 'overdue' THEN p.amount ELSE 0 END) as overdue_amount,
                        COUNT(CASE WHEN p.status = 'paid' THEN 1 END) as paid_count,
                        COUNT(CASE WHEN p.status = 'pending' THEN 1 END) as pending_count,
                        COUNT(CASE WHEN p.status = 'overdue' THEN 1 END) as overdue_count
                    FROM payments p
                    JOIN athletes a ON p.athlete_id = a.id
                    WHERE " . implode(' AND ', $where_conditions) . "
                ");
                $stmt->execute($params);
                $summary = $stmt->fetch();
                
                // Aylık ödeme dağılımı
                $stmt = $pdo->prepare("
                    SELECT 
                        MONTH(p.payment_date) as month,
                        COUNT(*) as payment_count,
                        SUM(p.amount) as total_amount,
                        SUM(CASE WHEN p.status = 'paid' THEN p.amount ELSE 0 END) as paid_amount
                    FROM payments p
                    JOIN athletes a ON p.athlete_id = a.id
                    WHERE " . implode(' AND ', $where_conditions) . "
                    GROUP BY MONTH(p.payment_date)
                    ORDER BY month
                ");
                $stmt->execute($params);
                $monthly_data = $stmt->fetchAll();
                
                // Sporcu bazlı özet
                $stmt = $pdo->prepare("
                    SELECT 
                        a.id,
                        a.first_name,
                        a.last_name,
                        COUNT(p.id) as payment_count,
                        SUM(p.amount) as total_amount,
                        SUM(CASE WHEN p.status = 'paid' THEN p.amount ELSE 0 END) as paid_amount,
                        SUM(CASE WHEN p.status = 'pending' THEN p.amount ELSE 0 END) as pending_amount
                    FROM athletes a
                    LEFT JOIN payments p ON a.id = p.athlete_id AND YEAR(p.payment_date) = ?
                    WHERE a.parent_id = ?
                    GROUP BY a.id, a.first_name, a.last_name
                    ORDER BY a.first_name, a.last_name
                ");
                $stmt->execute([$year, $user_id]); // user_id kullanıyoruz
                $athlete_summary = $stmt->fetchAll();
                
                $result = [
                    'summary' => [
                        'total_payments' => (int)$summary['total_payments'],
                        'total_amount' => (float)$summary['total_amount'],
                        'paid_amount' => (float)$summary['paid_amount'],
                        'pending_amount' => (float)$summary['pending_amount'],
                        'overdue_amount' => (float)$summary['overdue_amount'],
                        'paid_count' => (int)$summary['paid_count'],
                        'pending_count' => (int)$summary['pending_count'],
                        'overdue_count' => (int)$summary['overdue_count']
                    ],
                    'monthly_data' => $monthly_data,
                    'athlete_summary' => $athlete_summary
                ];
                
                api_response($result, 200, 'Ödeme özeti başarıyla getirildi');
                break;
                
            case 'detail':
                // Parent'ın user_id'sini al (parents tablosundan)
                $stmt = $pdo->prepare("SELECT user_id FROM parents WHERE id = ?");
                $stmt->execute([$parent_id]);
                $parent_record = $stmt->fetch();
                
                if ($parent_record) {
                    $user_id = $parent_record['user_id'];
                } else {
                    // Eski sistem uyumluluğu: parent_id direkt user_id olabilir
                    $user_id = $parent_id;
                }
                
                // Belirli bir ödeme detayı
                $payment_id = $_GET['id'] ?? '';
                
                if (!$payment_id) {
                    api_error('Ödeme ID gerekli', 400);
                }
                
                $stmt = $pdo->prepare("
                    SELECT 
                        p.*,
                        a.first_name,
                        a.last_name,
                        a.id as athlete_id
                    FROM payments p
                    JOIN athletes a ON p.athlete_id = a.id
                    WHERE p.id = ? AND a.parent_id = ?
                ");
                $stmt->execute([$payment_id, $user_id]); // user_id kullanıyoruz
                $payment = $stmt->fetch();
                
                if (!$payment) {
                    api_error('Ödeme bulunamadı', 404);
                }
                
                $payment['athlete_name'] = $payment['first_name'] . ' ' . $payment['last_name'];
                $payment['formatted_amount'] = number_format($payment['amount'], 2) . ' ₺';
                $payment['formatted_date'] = date('d.m.Y', strtotime($payment['payment_date']));
                $payment['status_text'] = $payment['status'] === 'paid' ? 'Ödendi' : 
                                        ($payment['status'] === 'pending' ? 'Bekliyor' : 'Gecikmiş');
                
                api_response($payment, 200, 'Ödeme detayları başarıyla getirildi');
                break;
                
            default:
                api_error('Geçersiz işlem', 400);
        }
        break;
        
    case 'POST':
        // Yeni ödeme talebi (isteğe bağlı)
        $input = json_decode(file_get_contents('php://input'), true);
        
        if (!$input || !isset($input['athlete_id']) || !isset($input['amount'])) {
            api_error('Sporcu ID ve tutar gerekli', 400);
        }
        
        $athlete_id = $input['athlete_id'];
        $amount = $input['amount'];
        $notes = $input['notes'] ?? '';
        
        // Sporcu kontrolü
        $stmt = $pdo->prepare("SELECT id FROM athletes WHERE id = ? AND parent_id = ?");
        $stmt->execute([$athlete_id, $user_id]); // user_id kullanıyoruz
        if (!$stmt->fetch()) {
            api_error('Sporcu bulunamadı', 404);
        }
        
        // Ödeme kaydı oluştur
        $stmt = $pdo->prepare("
            INSERT INTO payments (athlete_id, amount, payment_date, status, notes, created_at) 
            VALUES (?, ?, CURDATE(), 'pending', ?, NOW())
        ");
        $stmt->execute([$athlete_id, $amount, $notes]);
        
        $payment_id = $pdo->lastInsertId();
        
        api_response(['payment_id' => $payment_id], 201, 'Ödeme talebi başarıyla oluşturuldu');
        break;
        
    default:
        api_error('Desteklenmeyen HTTP metodu', 405);
}
?>

}
?>
