-- Tüm eksik tabloları ve kolonları düzelt

-- 1. Athletes tablosuna eksik kolonları ekle
ALTER TABLE athletes 
ADD COLUMN IF NOT EXISTS gender ENUM('male', 'female') NULL,
ADD COLUMN IF NOT EXISTS emergency_phone VARCHAR(20) NULL,
ADD COLUMN IF NOT EXISTS medical_notes TEXT NULL;

-- 2. Trainings tablosunu oluştur (training_schedules yerine)
CREATE TABLE IF NOT EXISTS trainings (
    id INT AUTO_INCREMENT PRIMARY KEY,
    athlete_id INT NOT NULL,
    training_date DATE NOT NULL,
    training_time TIME,
    location VARCHAR(100),
    notes TEXT,
    status ENUM('scheduled', 'completed', 'cancelled') DEFAULT 'scheduled',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (athlete_id) REFERENCES athletes(id) ON DELETE CASCADE,
    INDEX idx_athlete_date (athlete_id, training_date),
    INDEX idx_training_date (training_date)
);

-- 3. Notifications tablosuna eksik kolonları ekle
ALTER TABLE notifications 
ADD COLUMN IF NOT EXISTS parent_id INT NULL,
ADD COLUMN IF NOT EXISTS type ENUM('general', 'payment', 'training', 'attendance', 'urgent') DEFAULT 'general',
ADD COLUMN IF NOT EXISTS status ENUM('sent', 'delivered', 'failed') DEFAULT 'sent',
ADD COLUMN IF NOT EXISTS read_at TIMESTAMP NULL;

-- 4. Notifications tablosuna foreign key ekle
ALTER TABLE notifications 
ADD FOREIGN KEY (parent_id) REFERENCES parents(id) ON DELETE CASCADE;

-- 5. Notifications tablosuna index ekle
ALTER TABLE notifications 
ADD INDEX IF NOT EXISTS idx_parent_id (parent_id),
ADD INDEX IF NOT EXISTS idx_read_at (read_at);

