-- Veritabanı düzeltme script'i
-- Bu dosyayı phpMyAdmin veya MySQL client'ta çalıştırın

-- 1. user_type enum'ını güncelle
ALTER TABLE users MODIFY COLUMN user_type ENUM('admin', 'veli', 'parent') DEFAULT 'veli';

-- 2. last_login kolonunu ekle (eğer yoksa - hata verirse zaten var demektir)
ALTER TABLE users ADD COLUMN last_login TIMESTAMP NULL;

-- 3. Parents tablosunu oluştur
CREATE TABLE IF NOT EXISTS parents (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL UNIQUE,
    phone VARCHAR(20),
    address TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    INDEX idx_user_id (user_id)
);

-- 4. Mevcut veli kullanıcıları için parents kayıtları oluştur
INSERT IGNORE INTO parents (user_id, phone, address, created_at)
SELECT 
    u.id,
    u.phone,
    '',
    u.created_at
FROM users u
WHERE (u.user_type = 'veli' OR u.user_type = 'parent');

